/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity;

import javax.annotation.Nullable;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.procedures.BrolemOnSpawnProcedure;
import net.knifick.praporupdate.procedures.DarkironkinOnRMCProcedure;
import net.knifick.praporupdate.procedures.DarkironkinPerTickProcedure;
import net.knifick.praporupdate.procedures.IronkinReturnerProcedure;
import net.knifick.praporupdate.procedures.SoulSpawnConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DarkironkinEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_IsGrAttack = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_GrTimer = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_IsSmAttack = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_SmSwitcher = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_GrSwitchTimer = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_SmSwitchTimer = SynchedEntityData.defineId(DarkironkinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public DarkironkinEntity(EntityType<DarkironkinEntity> type, Level world) {
        super(type, world);
        this.xpReward = 50;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"dark_ironkin");
        builder.define(DATA_IsGrAttack, (Object)false);
        builder.define(DATA_GrTimer, (Object)0);
        builder.define(DATA_IsSmAttack, (Object)false);
        builder.define(DATA_SmSwitcher, (Object)false);
        builder.define(DATA_GrSwitchTimer, (Object)78);
        builder.define(DATA_SmSwitchTimer, (Object)84);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        BrolemOnSpawnProcedure.execute((Entity)this);
        return retval;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canContinueToUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() * 3.0f + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canContinueToUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canContinueToUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canContinueToUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DarkironkinEntity.this.getX();
                double y = DarkironkinEntity.this.getY();
                double z = DarkironkinEntity.this.getZ();
                DarkironkinEntity entity = DarkironkinEntity.this;
                Level world = DarkironkinEntity.this.level();
                return super.canContinueToUse() && IronkinReturnerProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:idle_iron"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:golem_steps")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.blaze.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:golem_death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        DarkironkinOnRMCProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataIsGrAttack", ((Boolean)this.entityData.get(DATA_IsGrAttack)).booleanValue());
        compound.putInt("DataGrTimer", ((Integer)this.entityData.get(DATA_GrTimer)).intValue());
        compound.putBoolean("DataIsSmAttack", ((Boolean)this.entityData.get(DATA_IsSmAttack)).booleanValue());
        compound.putBoolean("DataSmSwitcher", ((Boolean)this.entityData.get(DATA_SmSwitcher)).booleanValue());
        compound.putInt("DataGrSwitchTimer", ((Integer)this.entityData.get(DATA_GrSwitchTimer)).intValue());
        compound.putInt("DataSmSwitchTimer", ((Integer)this.entityData.get(DATA_SmSwitchTimer)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataIsGrAttack")) {
            this.entityData.set(DATA_IsGrAttack, (Object)compound.getBoolean("DataIsGrAttack"));
        }
        if (compound.contains("DataGrTimer")) {
            this.entityData.set(DATA_GrTimer, (Object)compound.getInt("DataGrTimer"));
        }
        if (compound.contains("DataIsSmAttack")) {
            this.entityData.set(DATA_IsSmAttack, (Object)compound.getBoolean("DataIsSmAttack"));
        }
        if (compound.contains("DataSmSwitcher")) {
            this.entityData.set(DATA_SmSwitcher, (Object)compound.getBoolean("DataSmSwitcher"));
        }
        if (compound.contains("DataGrSwitchTimer")) {
            this.entityData.set(DATA_GrSwitchTimer, (Object)compound.getInt("DataGrSwitchTimer"));
        }
        if (compound.contains("DataSmSwitchTimer")) {
            this.entityData.set(DATA_SmSwitchTimer, (Object)compound.getInt("DataSmSwitchTimer"));
        }
    }

    public void baseTick() {
        super.baseTick();
        DarkironkinPerTickProcedure.execute((Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)PraporModEntities.DARKIRONKIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> SoulSpawnConditionProcedure.execute((LevelAccessor)world), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 200.0);
        builder = builder.add(Attributes.ARMOR, 3.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !this.onGround() || this.isAggressive() || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("run"));
            }
            if (!this.onGround()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("fall"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("run"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("hit"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 104) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

