/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.knifick.praporupdate.goal.NarratorGoal;
import net.knifick.praporupdate.init.PraporModEntities;
import net.knifick.praporupdate.procedures.NarratorHurtProcedure;
import net.knifick.praporupdate.procedures.NarratorPerTickProcedure;
import net.knifick.praporupdate.procedures.NarratorToAdoptProcedure;
import net.knifick.praporupdate.util.narrator.MusicStopOnDeathHandler;
import net.knifick.praporupdate.util.narrator.MusicStopOnDistanceHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NarratorEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final Set<UUID> scaredPlayerUUIDs = new HashSet<UUID>();
    private int narratorState = 0;
    private int fleeTicks = 0;
    public static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_POWER_TIMER = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_IS_MUSIC = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<BlockPos> DATA_MUSIC_POS = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(NarratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    String prevAnim = "empty";

    public NarratorEntity(EntityType<NarratorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"narator_animated");
        builder.define(DATA_IS_POWERED, (Object)true);
        builder.define(DATA_POWER_TIMER, (Object)24000);
        builder.define(VARIANT, (Object)-1);
        builder.define(DATA_IS_MUSIC, (Object)false);
        builder.define(DATA_MUSIC_POS, (Object)new BlockPos(0, 0, 0));
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new NarratorGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return NarratorEntity.this.isPowered() && !NarratorEntity.this.isMusic() && super.canUse();
            }

            public boolean canContinueToUse() {
                return NarratorEntity.this.isPowered() && !NarratorEntity.this.isMusic() && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                return NarratorEntity.this.isPowered() && !NarratorEntity.this.isMusic() && super.canUse();
            }

            public boolean canContinueToUse() {
                return NarratorEntity.this.isPowered() && !NarratorEntity.this.isMusic() && super.canContinueToUse();
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"prapor:narator_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        NarratorHurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        Entity immediatesourceentity = source.getDirectEntity();
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        ListTag scaredPlayersTag = new ListTag();
        for (UUID uuid : this.scaredPlayerUUIDs) {
            scaredPlayersTag.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        compound.put("ScaredPlayers", (Tag)scaredPlayersTag);
        compound.putInt("NarratorState", this.narratorState);
        compound.putInt("FleeTicks", this.fleeTicks);
        compound.putBoolean("IsPowered", this.isPowered());
        compound.putInt("PowerTimer", this.getPowerTimer());
        compound.putBoolean("IsMusic", this.isMusic());
        compound.put("MusicPos", NbtUtils.writeBlockPos((BlockPos)this.getMusicPos()));
        compound.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        this.scaredPlayerUUIDs.clear();
        ListTag scaredPlayersTag = compound.getList("ScaredPlayers", 11);
        for (Tag entry : scaredPlayersTag) {
            this.scaredPlayerUUIDs.add(NbtUtils.loadUUID((Tag)entry));
        }
        this.narratorState = compound.getInt("NarratorState");
        this.fleeTicks = compound.getInt("FleeTicks");
        this.setPowered(compound.getBoolean("IsPowered"));
        this.setPowerTimer(compound.getInt("PowerTimer"));
        this.setMusic(compound.getBoolean("IsMusic"));
        if (compound.contains("MusicPos")) {
            this.setMusicPos(NbtUtils.readBlockPos((CompoundTag)compound, (String)"MusicPos").orElse(BlockPos.ZERO));
        }
        this.setVariant(compound.getInt("Variant"));
    }

    public Set<UUID> getScaredPlayers() {
        return this.scaredPlayerUUIDs;
    }

    public boolean isPowered() {
        return (Boolean)this.entityData.get(DATA_IS_POWERED);
    }

    public void setPowered(boolean powered) {
        this.entityData.set(DATA_IS_POWERED, (Object)powered);
    }

    public int getPowerTimer() {
        return (Integer)this.entityData.get(DATA_POWER_TIMER);
    }

    public void setPowerTimer(int ticks) {
        this.entityData.set(DATA_POWER_TIMER, (Object)ticks);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public boolean isMusic() {
        return (Boolean)this.entityData.get(DATA_IS_MUSIC);
    }

    public void setMusic(boolean music) {
        this.entityData.set(DATA_IS_MUSIC, (Object)music);
    }

    public BlockPos getMusicPos() {
        return (BlockPos)this.entityData.get(DATA_MUSIC_POS);
    }

    public void setMusicPos(BlockPos pos) {
        this.entityData.set(DATA_MUSIC_POS, (Object)pos);
    }

    public void die(DamageSource source) {
        if (!this.level().isClientSide && this.isMusic()) {
            MusicStopOnDeathHandler.stopMusicForNarrator(this);
        }
        super.die(source);
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        if (this.isTame() && this.getOwner() != sourceentity) {
            return InteractionResult.CONSUME;
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        NarratorEntity entity = this;
        Level world = this.level();
        System.out.println("Server: " + world.isClientSide);
        if (this.level().isClientSide) {
            return retval;
        }
        NarratorToAdoptProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return InteractionResult.CONSUME;
    }

    private void rejectDisk() {
        MusicStopOnDistanceHandler.StopMusic(this);
        this.setMusic(false);
        this.setAnimation("empty");
        double xr = RandomSource.create().nextDouble() * 0.2 - 0.1;
        double zr = RandomSource.create().nextDouble() * 0.2 - 0.1;
        ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), this.getItemInHand(InteractionHand.MAIN_HAND).copy());
        item.setDeltaMovement(new Vec3(xr, 0.3, zr));
        this.level().addFreshEntity((Entity)item);
        this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
    }

    public void baseTick() {
        super.baseTick();
        if (this.getPowerTimer() > 0) {
            this.setPowerTimer(this.getPowerTimer() - 1);
        } else {
            this.setPowered(false);
            this.rejectDisk();
            this.setAnimation("BatteryChange");
        }
        BlockPos blockPos = this.getMusicPos();
        int mobX = (int)this.getX();
        int mobY = (int)this.getY();
        int mobZ = (int)this.getZ();
        Vec3i mobPos = new Vec3i(mobX, mobY, mobZ);
        double distanceSquared = blockPos.distSqr(mobPos);
        double distance = Math.sqrt(distanceSquared);
        if (this.isMusic() && distance > 5.0) {
            this.rejectDisk();
        }
        NarratorPerTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        BlockPos pos = this.blockPosition();
        Holder biomeHolder = world.getBiome(pos);
        ResourceKey biomeKey = biomeHolder.getKey();
        if (biomeKey.location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_slopes")) || biomeKey.location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_beach")) || biomeKey.location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_plains")) || biomeKey.location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_taiga")) || biomeKey.location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ice_spikes"))) {
            this.setVariant(2);
        } else {
            this.setVariant(1);
        }
        return retval;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        NarratorEntity retval = (NarratorEntity)((EntityType)PraporModEntities.NARRATOR.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.isMusic()) {
            this.getNavigation().stop();
            this.setDeltaMovement(new Vec3(0.0, this.getDeltaMovement().y, 0.0));
        }
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)PraporModEntities.NARRATOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.7);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isShiftKeyDown()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

