/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.hat;

import net.knifick.praporupdate.init.PraporModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class VillagerHat {
    @SubscribeEvent
    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (player.level().isClientSide() || event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack headItem = player.getItemBySlot(EquipmentSlot.HEAD);
        if (headItem.is((Item)PraporModItems.HAT_HELMET.get())) {
            event.setCanceled(true);
            double x = villager.getX();
            double y = villager.getY();
            double z = villager.getZ();
            villager.level().playSound(null, villager.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.0f);
            Level level = villager.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, x, y + 1.4, z, 4, 0.2, 0.2, 0.2, 1.0);
            }
        }
    }
}

