/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.event.mace;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.knifick.praporupdate.init.PraporModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@EventBusSubscriber(modid="prapor")
public class BMaceKillEvent {
    private static final Map<UUID, Integer> LAST_HOTBAR_SLOT = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent e) {
        Player player = e.getEntity();
        LAST_HOTBAR_SLOT.put(player.getUUID(), player.getInventory().selected);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        Entity entity = e.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!e.getSource().getWeaponItem().is((Item)PraporModItems.BETTER_MACE.get())) {
            return;
        }
        Integer slot = LAST_HOTBAR_SLOT.get(player.getUUID());
        ItemStack weapon = e.getSource().getWeaponItem();
        ItemStack newWeapon = new ItemStack((ItemLike)PraporModItems.BETTER_MACE_CHARGED.get());
        newWeapon.setDamageValue(weapon.getDamageValue() + 1);
        if (slot != null && slot >= 0) {
            player.getInventory().setItem(slot.intValue(), newWeapon);
        }
    }
}

