/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.init;

import net.knifick.praporupdate.entity.BastardEntity;
import net.knifick.praporupdate.entity.BrolemEntity;
import net.knifick.praporupdate.entity.DarkironkinEntity;
import net.knifick.praporupdate.entity.NarratorEntity;
import net.knifick.praporupdate.entity.PookerEntity;
import net.knifick.praporupdate.entity.PraporEntity;
import net.knifick.praporupdate.entity.SoulEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class PraporModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"prapor");
    public static final DeferredHolder<EntityType<?>, EntityType<PraporEntity>> PRAPOR = PraporModEntities.register("prapor", EntityType.Builder.of(PraporEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<PookerEntity>> POOKER = PraporModEntities.register("pooker", EntityType.Builder.of(PookerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).fireImmune().sized(2.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SoulEntity>> SOUL = PraporModEntities.register("soul", EntityType.Builder.of(SoulEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.2f, 0.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<NarratorEntity>> NARRATOR = PraporModEntities.register("narrator", EntityType.Builder.of(NarratorEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<BastardEntity>> BASTARD = PraporModEntities.register("bastard", EntityType.Builder.of(BastardEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<BrolemEntity>> BROLEM = PraporModEntities.register("brolem", EntityType.Builder.of(BrolemEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.4f, 2.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkironkinEntity>> DARKIRONKIN = PraporModEntities.register("darkironkin", EntityType.Builder.of(DarkironkinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.2f, 2.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        PraporEntity.init(event);
        PookerEntity.init(event);
        SoulEntity.init(event);
        NarratorEntity.init(event);
        BastardEntity.init(event);
        BrolemEntity.init(event);
        DarkironkinEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PRAPOR.get(), PraporEntity.createAttributes().build());
        event.put((EntityType)POOKER.get(), PookerEntity.createAttributes().build());
        event.put((EntityType)SOUL.get(), SoulEntity.createAttributes().build());
        event.put((EntityType)NARRATOR.get(), NarratorEntity.createAttributes().build());
        event.put((EntityType)BASTARD.get(), BastardEntity.createAttributes().build());
        event.put((EntityType)BROLEM.get(), BrolemEntity.createAttributes().build());
        event.put((EntityType)DARKIRONKIN.get(), DarkironkinEntity.createAttributes().build());
    }
}

