/*
 * Decompiled with CFR 0.152.
 */
package net.knifick.praporupdate.util.narrator;

import net.knifick.praporupdate.entity.NarratorEntity;
import net.knifick.praporupdate.init.PraporModItems;
import net.knifick.praporupdate.init.PraporModSounds;
import net.knifick.praporupdate.procedures.NarratorToAdoptProcedure;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class MusicStopOnDeathHandler {
    public static void stopMusicForNarrator(NarratorEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            Holder.Reference<SoundEvent> soundEvent;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.level().isClientSide) {
                return;
            }
            if (!(entity instanceof NarratorEntity)) {
                return;
            }
            NarratorEntity narrator = entity;
            if (!narrator.isMusic()) {
                return;
            }
            narrator.setMusic(false);
            ResourceLocation soundId = null;
            ItemStack discStack = narrator.getItemInHand(InteractionHand.MAIN_HAND);
            if (discStack.getItem() == PraporModItems.MUSIC_RECORD_N_42.get()) {
                soundId = PraporModSounds.SOUND_TRACK.getId();
            } else if (discStack.getItem() == PraporModItems.MUSIC_RECORD_THANKS_STREET.get()) {
                soundId = PraporModSounds.THANKS_STREET.getId();
            } else if (discStack.is(Tags.Items.MUSIC_DISCS) && (soundEvent = NarratorToAdoptProcedure.musics.get(discStack.getItem())) != null) {
                soundId = ((SoundEvent)soundEvent.value()).getLocation();
            }
            if (soundId != null) {
                MusicStopOnDeathHandler.stopSoundForAllPlayers(serverLevel, soundId);
            }
        }
    }

    private static void stopSoundForAllPlayers(ServerLevel level, ResourceLocation soundId) {
        for (ServerPlayer player : level.getServer().getPlayerList().getPlayers()) {
            player.connection.send((Packet)new ClientboundStopSoundPacket(soundId, SoundSource.RECORDS));
        }
    }
}

