/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class DrawSector {
    public static void draw(int outerRadius, double startAngle, double endAngle, int color) {
        DrawSector.draw(0, outerRadius, startAngle, endAngle, color, Math.PI / 180);
    }

    public static void draw(int outerRadius, double startAngle, double endAngle, int color, double arc) {
        DrawSector.draw(0, outerRadius, startAngle, endAngle, color, arc);
    }

    public static void draw(int innerRadius, int outerRadius, double startAngle, double endAngle, int color) {
        DrawSector.draw(innerRadius, outerRadius, startAngle, endAngle, color, Math.PI / 180);
    }

    public static void draw(int innerRadius, int outerRadius, double startAngle, double endAngle, int color, double arc) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (double angle = startAngle; angle <= endAngle - arc; angle += arc) {
            float x2 = (float)(Math.cos(angle) * (double)outerRadius);
            float y2 = (float)(Math.sin(angle) * (double)outerRadius);
            buffer.addVertex(x2, y2, 0.0f).setColor(color);
            float x1 = (float)(Math.cos(angle) * (double)innerRadius);
            float y1 = (float)(Math.sin(angle) * (double)innerRadius);
            buffer.addVertex(x1, y1, 0.0f).setColor(color);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void draw(Matrix4f matrix4f, int innerRadius, int outerRadius, double startArc, double endArc, int color) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (double a = startArc; a < endArc; a += Math.PI / 180) {
            double x2 = Math.cos(a) * (double)outerRadius;
            double y2 = Math.sin(a) * (double)outerRadius;
            buffer.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(color);
            double x1 = Math.cos(a) * (double)innerRadius;
            double y1 = Math.sin(a) * (double)innerRadius;
            buffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(color);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void draw(PoseStack poseStack, int innerRadius, int outerRadius, double startArc, double endArc, int color) {
        DrawSector.draw(poseStack.last().pose(), innerRadius, outerRadius, startArc, endArc, color);
    }

    public static void draw(PoseStack poseStack, int innerRadiusX, int innerRadiusY, int outerRadiusX, int outerRadiusY, double startArc, double endArc, int color) {
        DrawSector.draw(poseStack.last().pose(), innerRadiusX, innerRadiusY, outerRadiusX, outerRadiusY, startArc, endArc, color);
    }

    public static void draw(Matrix4f matrix4f, int innerRadiusX, int innerRadiusY, int outerRadiusX, int outerRadiusY, double startArc, double endArc, int color) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (double a = startArc; a < endArc; a += Math.PI / 180) {
            double x2 = Math.cos(a) * (double)outerRadiusX;
            double y2 = Math.sin(a) * (double)outerRadiusY;
            buffer.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(color);
            double x1 = Math.cos(a) * (double)innerRadiusX;
            double y1 = Math.sin(a) * (double)innerRadiusY;
            buffer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(color);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }
}

