/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class DrawSphere {
    public static final RenderType SPHERE_RENDER_TYPE = RenderType.create((String)"sphere_render_type", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));

    public static void draw(PoseStack poseStack, MultiBufferSource bufferSource, float radius, int slices, int stacks, int color) {
        VertexConsumer consumer = bufferSource.getBuffer(SPHERE_RENDER_TYPE);
        Matrix4f modelViewMatrix = poseStack.last().pose();
        Matrix3f normalMatrix = poseStack.last().normal();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (int i = 0; i < stacks; ++i) {
            float phi = (float)Math.PI * (float)i / (float)stacks;
            float sinPhi = (float)Math.sin(phi);
            float cosPhi = (float)Math.cos(phi);
            for (int j = 0; j < slices; ++j) {
                float theta = (float)(Math.PI * 2 * (double)j / (double)slices);
                float sinTheta = (float)Math.sin(theta);
                float cosTheta = (float)Math.cos(theta);
                float x = radius * sinPhi * cosTheta;
                float y = radius * cosPhi;
                float z = radius * sinPhi * sinTheta;
                float theta_next = (float)(Math.PI * 2 * (double)(j + 1) / (double)slices);
                float sinTheta_next = (float)Math.sin(theta_next);
                float cosTheta_next = (float)Math.cos(theta_next);
                float x_next = radius * sinPhi * cosTheta_next;
                float y_next = radius * cosPhi;
                float z_next = radius * sinPhi * sinTheta_next;
                float phi_up = (float)Math.PI * (float)(i + 1) / (float)stacks;
                float sinPhi_up = (float)Math.sin(phi_up);
                float cosPhi_up = (float)Math.cos(phi_up);
                float x_up = radius * sinPhi_up * cosTheta;
                float y_up = radius * cosPhi_up;
                float z_up = radius * sinPhi_up * sinTheta;
                float x_up_next = radius * sinPhi_up * cosTheta_next;
                float y_up_next = radius * cosPhi_up;
                float z_up_next = radius * sinPhi_up * sinTheta_next;
                consumer.addVertex(modelViewMatrix, x, y, z).setColor(r, g, b, a).setNormal(poseStack.last(), x, y, z);
                consumer.addVertex(modelViewMatrix, x_next, y_next, z_next).setColor(r, g, b, a).setNormal(poseStack.last(), x_next, y_next, z_next);
                consumer.addVertex(modelViewMatrix, x_up, y_up, z_up).setColor(r, g, b, a).setNormal(poseStack.last(), x_up, y_up, z_up);
                consumer.addVertex(modelViewMatrix, x_next, y_next, z_next).setColor(r, g, b, a).setNormal(poseStack.last(), x_next, y_next, z_next);
                consumer.addVertex(modelViewMatrix, x_up_next, y_up_next, z_up_next).setColor(r, g, b, a).setNormal(poseStack.last(), x_up_next, y_up_next, z_up_next);
                consumer.addVertex(modelViewMatrix, x_up, y_up, z_up).setColor(r, g, b, a).setNormal(poseStack.last(), x_up, y_up, z_up);
            }
        }
    }
}

