/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.am.color.ColorConfig;
import dev.anye.mc.cores.am.color.ColorConfigData;
import dev.anye.mc.cores.am.color.ColorSchemeRegister;
import dev.anye.mc.cores.am.color.ColorSchemes;
import dev.anye.mc.cores.screen.bs.BorderStyles;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.c.CWidgetButton;
import dev.anye.mc.cores.screen.widget.c.CWidgetDropDownSelectBox;
import dev.anye.mc.cores.screen.widget.c.CWidgetLabel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SettingScreen
extends Screen {
    CWidgetDropDownSelectBox colorSelectBox;
    CWidgetButton saveButton;

    public SettingScreen() {
        super((Component)Component.translatable((String)"screen.cores.settings.title"));
    }

    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.saveButton = new CWidgetButton(new _BoundingBox(x - 32, this.height - 64, 64, 16), BorderStyles.DEFAULT, (Component)Component.translatable((String)"screen.cores.settings.button.save"), this::save);
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        CWidgetLabel label = new CWidgetLabel(new _BoundingBox(16, 16, 16, 16), BorderStyles.DEFAULT, (Component)Component.translatable((String)"screen.cores.settings.label.select_color"));
        this.addRenderableWidget((GuiEventListener)label);
        this.colorSelectBox = new CWidgetDropDownSelectBox(new _BoundingBox(label.getX() + label.getWidth() + 5, label.getY(), 80, 16), BorderStyles.DEFAULT, ColorSchemeRegister.getSchemeComponent(ColorSchemes.getGlobal()), 7, true, this.getRegColor());
        this.addRenderableWidget((GuiEventListener)this.colorSelectBox);
    }

    private void save() {
        Object object;
        DT_ListBoxData d = this.colorSelectBox.getSelectData();
        if (d != null && (object = d.getValue()) instanceof _ColorScheme) {
            _ColorScheme colorScheme = (_ColorScheme)object;
            String key = ColorSchemeRegister.REGISTRY.getKey((Object)colorScheme).toString();
            ((ColorConfigData)ColorConfig.instance.getDatas()).setColorScheme(key);
            ColorConfig.instance.save();
            ColorSchemes.setGlobal(colorScheme);
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new SettingScreen());
            }
        }
    }

    public List<DT_ListBoxData> getRegColor() {
        ArrayList<DT_ListBoxData> data2 = new ArrayList<DT_ListBoxData>();
        ColorSchemeRegister.REGISTRY.forEach(colorScheme -> data2.add(new DT_ListBoxData(ColorSchemeRegister.getSchemeComponent(colorScheme), colorScheme)));
        return data2;
    }
}

