/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.bs;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.screen.bs.BorderStyle;
import net.minecraft.client.gui.GuiGraphics;

public class LineBorderStyle
extends BorderStyle {
    private final int size;

    public LineBorderStyle() {
        this(1);
    }

    public LineBorderStyle(int size) {
        super(size, size, size, size);
        this.size = size;
    }

    @Override
    public void render(GuiGraphics guiGraphics, _BoundingBox boundingBox, _ColorScheme colorScheme, int mouseX, int mouseY) {
        boolean hover = this.isHover(boundingBox, mouseX, mouseY);
        _ColorScheme.Color border = colorScheme.getColor("border");
        int borderColor = hover ? border.HoverColor() : border.UsualColor();
        _ColorScheme.Color background = colorScheme.getColor("background");
        int fillColor = hover ? background.HoverColor() : background.UsualColor();
        guiGraphics.fill(boundingBox.getX(), boundingBox.getY(), boundingBox.getMaxX(), boundingBox.getY() + this.size, borderColor);
        guiGraphics.fill(boundingBox.getX(), boundingBox.getMaxY() - this.size, boundingBox.getMaxX(), boundingBox.getMaxY(), borderColor);
        guiGraphics.fill(boundingBox.getX(), boundingBox.getY() + this.size, boundingBox.getX() + this.size, boundingBox.getMaxY() - this.size, borderColor);
        guiGraphics.fill(boundingBox.getMaxX() - this.size, boundingBox.getY() + this.size, boundingBox.getMaxX(), boundingBox.getMaxY() - this.size, borderColor);
        guiGraphics.fill(boundingBox.getX() + this.size, boundingBox.getY() + this.size, boundingBox.getMaxX() - this.size, boundingBox.getMaxY() - this.size, fillColor);
        boundingBox.retraction(this.size);
    }
}

