/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.bs;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.render.BufferHelper;
import dev.anye.mc.cores.render.DrawSector;
import dev.anye.mc.cores.screen.bs.BorderStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class RoundedBorderStyle
extends BorderStyle {
    private int radius;

    public RoundedBorderStyle(int radius) {
        super(radius, radius, radius, radius);
        this.setRadius(radius);
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void render(GuiGraphics guiGraphics, _BoundingBox boundingBox, _ColorScheme colorScheme, int mouseX, int mouseY) {
        boolean hover = this.isHover(boundingBox, mouseX, mouseY);
        _ColorScheme.Color border = colorScheme.getColor("border");
        int borderColor = hover ? border.HoverColor() : border.UsualColor();
        _ColorScheme.Color background = colorScheme.getColor("background");
        int fillColor = hover ? background.HoverColor() : background.UsualColor();
        this.drawRoundedRect(guiGraphics.pose(), boundingBox.getX(), boundingBox.getY(), boundingBox.getW(), boundingBox.getH(), this.radius, borderColor, fillColor);
        boundingBox.retraction(this.radius);
    }

    protected void drawRoundedRect(PoseStack poseStack, int x, int y, int width, int height, int radius, int borderColor, int fillColor) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + radius, fillColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + radius, fillColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + height - radius, fillColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + height - radius, fillColor);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        poseStack.pushPose();
        matrix = poseStack.last().pose();
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        this.drawBorder(buffer, matrix, x, y, width, height, radius, borderColor);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        this.drawCorners(poseStack, x, y, width, height, radius, borderColor);
        RenderSystem.disableBlend();
    }

    protected void drawBorder(BufferBuilder buffer, Matrix4f matrix, int x, int y, int width, int height, int radius, int borderColor) {
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + height - radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + height - radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + height, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + height, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + radius, y + height - radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x, y + height - radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width, y + radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width, y + height - radius, borderColor);
        BufferHelper.addColorVertex(buffer, matrix, x + width - radius, y + height - radius, borderColor);
    }

    protected void drawCorners(PoseStack poseStack, int x, int y, int width, int height, int radius, int color) {
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.translate((float)radius, (float)radius, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, Math.PI, 4.71238898038469, color);
        poseStack.translate((float)(width - 2 * radius), 0.0f, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 4.71238898038469, Math.PI * 2, color);
        poseStack.translate(0.0f, (float)(height - 2 * radius), 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 0.0, 1.5707963267948966, color);
        poseStack.translate((float)(-(width - 2 * radius)), 0.0f, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 1.5707963267948966, Math.PI, color);
        poseStack.popPose();
    }
}

