/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.anye.core.debug._DeBug;
import dev.anye.mc.cores.render.DrawSector;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CircularWidget
extends RenderWidgetCore<CircularWidget> {
    protected FlipMode flipMode;
    protected int sectors;
    protected int innerRadius;
    protected int outerRadius;
    protected double fanAngle;
    protected double fanArc;
    protected double halfFanArc;
    protected List<DT_ListBoxData> data;
    protected int index = -1;
    protected int startIndex = 0;
    protected int fanTextInnerSpace;

    public CircularWidget(int x, int y, int w, int h, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, Component message, List<DT_ListBoxData> data2) {
        this(x, y, w, h, 9, 20, 80, message, data2);
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, List<DT_ListBoxData> data2) {
        super(x, y, w, h, message);
        if (sectors < 1) {
            _DeBug.ThrowError((String)"error sectors");
        }
        this.setData(data2);
        this.setSectors(sectors);
        this.setInnerRadius(innerRadius);
        this.setOuterRadius(outerRadius);
        this.setFlipMode(FlipMode.tire);
        this.setFanTextInnerSpace(10);
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, highlightColor, normalColor, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, List<DT_ListBoxData> data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, message, data2);
        this.setBackgroundHoverColor(highlightColor);
        this.setBackgroundUsualColor(normalColor);
    }

    public void setData(List<DT_ListBoxData> data2) {
        this.data = data2;
    }

    public void setFanTextInnerSpace(int fanTextInnerSpace) {
        this.fanTextInnerSpace = fanTextInnerSpace;
    }

    public void setFlipMode(FlipMode flipMode) {
        this.flipMode = flipMode;
    }

    public void setFanArc(double fanArc) {
        this.fanArc = fanArc;
        this.setHalfFanArc(fanArc / 2.0);
    }

    public void setHalfFanArc(double halfFanArc) {
        this.halfFanArc = halfFanArc;
    }

    public int getFanTextInnerSpace() {
        return Math.max(this.fanTextInnerSpace, this.innerRadius);
    }

    public void setFanAngle(double fanAngle) {
        this.fanAngle = fanAngle;
    }

    public void setOuterRadius(int outerRadius) {
        this.outerRadius = outerRadius;
    }

    public void setSectors(int sectors) {
        this.sectors = sectors;
        this.setFanAngle(360.0 / (double)sectors);
        this.setFanArc(Math.PI * 2 / (double)sectors);
    }

    public void setInnerRadius(int innerRadius) {
        this.innerRadius = innerRadius;
    }

    public DT_ListBoxData getData() {
        return this.getData(this.index);
    }

    public DT_ListBoxData getData(int index) {
        if (this.isValidIndex(index)) {
            return this.data.get(index);
        }
        return null;
    }

    public boolean isValidIndex() {
        return this.isValidIndex(this.index);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.data.size();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.active && this.visible && this.flipMode == FlipMode.button) {
            if (pButton == 0) {
                if (this.startIndex >= this.sectors) {
                    this.startIndex -= this.sectors;
                    return true;
                }
            } else if (pButton == 1 && this.data.size() > this.startIndex + this.sectors) {
                this.startIndex += this.sectors;
                return true;
            }
            return false;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void onClick(double pMouseX, double pMouseY, int button) {
        DT_ListBoxData dtListBoxData;
        if (this.flipMode == FlipMode.tire && (dtListBoxData = this.getData()) != null) {
            dtListBoxData.OnPress(dtListBoxData.getValue());
        }
        super.onClick(pMouseX, pMouseY, button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.flipMode == FlipMode.tire) {
            if (pScrollY > 0.0) {
                if (this.startIndex >= this.sectors) {
                    this.startIndex -= this.sectors;
                    return true;
                }
            } else if (this.data.size() > this.startIndex + this.sectors) {
                this.startIndex += this.sectors;
                return true;
            }
            return false;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.visible) {
            int centerX = this.getX();
            int centerY = this.getY();
            double angle = Math.atan2(mouseY - centerY, mouseX - centerX) + this.halfFanArc;
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            for (int i = 0; i < this.sectors; ++i) {
                int sIndex = this.startIndex + i;
                double startAngle = (double)i * this.fanArc;
                double endAngle = (double)(i + 1) * this.fanArc;
                int bgc = this.getBackgroundUsualColor();
                int tc = this.getTextUsualColor();
                float size = 1.0f;
                if (angle >= startAngle && angle < endAngle) {
                    bgc = this.getBackgroundHoverColor();
                    tc = this.getTextHoverColor();
                    size = 1.3f;
                    this.index = sIndex;
                }
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)centerX, (float)centerY, 0.0f);
                poseStack.mulPose(Axis.ZP.rotation((float)startAngle));
                DrawSector.draw(poseStack.last().pose(), this.innerRadius, this.outerRadius, -this.halfFanArc, this.halfFanArc, bgc);
                if (this.isValidIndex(sIndex)) {
                    DT_ListBoxData boxData = this.getData(sIndex);
                    this.drawName(guiGraphics, startAngle, boxData.getComponent().getString(), tc, size);
                }
                poseStack.popPose();
            }
        }
    }

    public void drawTextName(GuiGraphics guiGraphics, String name, int color) {
        name = this.font.plainSubstrByWidth(name, this.outerRadius - this.getFanTextInnerSpace());
        int n = this.getFanTextInnerSpace();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, name, n, -9 / 2, color, false);
    }

    protected void drawName(GuiGraphics guiGraphics, double rad, String name, int color, float size) {
        ResourceLocation res = ResourceLocation.tryParse((String)name);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        if (res != null) {
            double r = (double)this.getFanTextInnerSpace() + (double)(this.outerRadius - this.innerRadius) / 2.0;
            double x2 = Math.cos(rad) * r;
            double y2 = Math.sin(rad) * r;
            pose.mulPose(Axis.ZP.rotation((float)(-rad)));
            pose.translate(x2, y2, 0.0);
            pose.scale(size, size, size);
            guiGraphics.blit(res, -8, -8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            pose.scale(size, size, size);
            this.drawTextName(guiGraphics, name, color);
        }
        pose.popPose();
    }

    public static enum FlipMode {
        tire,
        button;

    }
}

