/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.anye.core.color._ColorCDT;
import dev.anye.core.debug._DeBug;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.DT_XYWH;
import dev.anye.mc.cores.screen.widget.DropDownListBoxCore;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DropDownListBox
extends DropDownListBoxCore {
    private final DT_XYWH dt_xywh;
    private List<DT_ListBoxData> dataList;
    private final Component msg;
    private int nowSelectIndex = -1;
    private boolean showList = false;
    private int line;
    private int lineHeight;
    private int linePosY;
    private int pages;
    private int nowPage;
    private int layerZ = 300;

    public DropDownListBox(int x, int y, int w, int h, Component pMessage, DT_ListBoxData ... data2) {
        this(x, y, w, h, pMessage, Arrays.asList(data2));
    }

    public DropDownListBox(int x, int y, int w, int h, Component pMessage, List<DT_ListBoxData> data2) {
        super(x, y, w, h, pMessage);
        this.dt_xywh = new DT_XYWH(x, y, w, h);
        this.texture = null;
        this.setTextColor(_ColorCDT.black, _ColorCDT.black, _ColorCDT.blue);
        this.setBgColor(Color.LIGHT_GRAY.getRGB(), _ColorCDT.white, Color.GRAY.getRGB());
        this.dataList = data2;
        this.msg = pMessage;
        this.setLine(7);
    }

    public void setDataList(DT_ListBoxData ... data2) {
        this.setDataList(Arrays.asList(data2));
    }

    public void setDataList(List<DT_ListBoxData> dataList) {
        this.nowPage = 1;
        this.nowSelectIndex = -1;
        this.dataList = dataList;
    }

    public void setLine(int line) {
        this.line = line;
        this.lineHeight = this.dt_xywh.height() * line;
        int n = this.dt_xywh.height();
        Objects.requireNonNull(this.font);
        int a = n - 9;
        this.linePosY = a > 0 ? a / 2 : 0;
        this.pages = this.getPages(this.dataList.size(), line);
        this.nowPage = 1;
    }

    public int getPages(int number, int line) {
        int n = number / line;
        if (number % line != 0) {
            ++n;
        }
        return n;
    }

    public List<DT_ListBoxData> getDataList() {
        return this.dataList;
    }

    public Component getSelectComponent() {
        DT_ListBoxData dropDownListBoxData = this.getSelectData();
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"---NULL---");
    }

    public Component getComponent(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"---NULL---");
    }

    public List<Component> getDataTooltip(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getTooltip();
        }
        return List.of(Component.literal((String)"---NULL---"));
    }

    public DT_ListBoxData getSelectData() {
        if (this.nowSelectIndex >= 0 && this.nowSelectIndex < this.dataList.size()) {
            return this.dataList.get(this.nowSelectIndex);
        }
        return null;
    }

    public DT_ListBoxData getData(int index) {
        int i = (this.nowPage - 1) * this.line + index;
        if (i >= 0 && i < this.dataList.size()) {
            return this.dataList.get(i);
        }
        return null;
    }

    public Object getSelectValue() {
        if (this.nowSelectIndex > this.dataList.size() || this.nowSelectIndex < 0) {
            _DeBug.ThrowError((String)"Error Select");
            return null;
        }
        return this.dataList.get(this.nowSelectIndex).getValue();
    }

    public boolean setSelect(int index) {
        if (index > this.dataList.size() || index < 0) {
            return false;
        }
        this.nowSelectIndex = index;
        return true;
    }

    public int getNowSelectIndex() {
        return this.nowSelectIndex;
    }

    public void setLayerZ(int z) {
        this.layerZ = z;
    }

    public String FixStrWidth(String s) {
        return this.font.plainSubstrByWidth(s, this.width);
    }

    public String FixStrWidth(Component s) {
        return this.FixStrWidth(s.getString());
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        if (this.showList) {
            poseStack.translate(0.0f, 0.0f, (float)(this.layerZ + 1));
        } else {
            poseStack.translate(0.0f, 0.0f, (float)this.layerZ);
        }
        if (this.texture == null) {
            guiGraphics.fill(this.dt_xywh.x(), this.dt_xywh.y(), this.dt_xywh.x() + this.width, this.dt_xywh.y() + this.dt_xywh.height(), this.bgSelectColor);
        } else {
            guiGraphics.blit(this.texture, this.getX(), this.getY(), 0, 0, this.width, this.height);
        }
        Component c = this.msg;
        if (this.nowSelectIndex > -1 || c == null || c.equals((Object)Component.empty())) {
            c = this.getSelectComponent();
        }
        this.drawStr(guiGraphics, (Component)Component.literal((String)this.FixStrWidth(c)), this.dt_xywh.x(), this.dt_xywh.y() + this.linePosY, this.textSelectColor);
        if (this.showList) {
            for (int i = 0; i < this.line; ++i) {
                int lineY = this.getY() + (i + 1) * this.dt_xywh.height();
                Component select = this.getComponent(i);
                int bgc = this.bgUsualColor;
                int hc = this.textUsualColor;
                if (pMouseX > this.getX() && pMouseX < this.getX() + this.width && pMouseY > lineY && pMouseY < lineY + this.dt_xywh.height()) {
                    bgc = this.bgHoverColor;
                    hc = this.textHoverColor;
                    guiGraphics.renderTooltip(this.font, this.getDataTooltip(i), Optional.empty(), pMouseX, pMouseY);
                }
                if (this.texture == null) {
                    guiGraphics.fill(this.dt_xywh.x(), lineY, this.dt_xywh.x() + this.width, lineY + this.dt_xywh.height(), bgc);
                }
                this.drawStr(guiGraphics, (Component)Component.literal((String)this.FixStrWidth(select)), this.getX(), lineY + this.linePosY, hc);
            }
        }
        poseStack.popPose();
    }

    public void onClick(double pMouseX, double pMouseY) {
        super.onClick(pMouseX, pMouseY);
        boolean bl = this.showList = !this.showList;
        if (this.showList) {
            this.setHeight(this.dt_xywh.height() + this.lineHeight);
        } else {
            this.setHeight(this.dt_xywh.height());
        }
        this.updateIndex(pMouseY);
    }

    public void updateIndex(double mouseY) {
        int i = (int)((mouseY - (double)this.getY()) / (double)this.dt_xywh.height());
        if (i > 0) {
            this.nowSelectIndex = i - 1;
            this.nowSelectIndex += (this.nowPage - 1) * this.line;
            DT_ListBoxData dropDownListBoxData = this.getSelectData();
            if (dropDownListBoxData != null) {
                dropDownListBoxData.OnPress(this.getSelectValue());
            }
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (this.showList && this.isInWidget(pMouseX, pMouseY)) {
            if (sy < 0.0 && this.nowPage < this.pages) {
                ++this.nowPage;
            } else if (sy > 0.0 && this.nowPage > 1) {
                --this.nowPage;
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"block.nu.equipment_enhancer"));
    }
}

