/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DropDownListBoxCore
extends AbstractWidget
implements Renderable {
    protected ResourceLocation texture;
    protected Font font;
    protected int textUsualColor;
    protected int textSelectColor;
    protected int textHoverColor;
    protected int bgUsualColor;
    protected int bgSelectColor;
    protected int bgHoverColor;
    protected boolean textShadow;

    public DropDownListBoxCore(int pX, int pY, int pWidth, int pHeight, Component pMessage) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.font = Minecraft.getInstance().font;
        this.textShadow = false;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setTextColor(int textColor, int textSelectColor, int textHoverColor) {
        this.setTextUsualColor(textColor);
        this.setTextSelectColor(textSelectColor);
        this.setTextHoverColor(textHoverColor);
    }

    public void setTextUsualColor(int textUsualColor) {
        this.textUsualColor = textUsualColor;
    }

    public void setTextSelectColor(int textSelectColor) {
        this.textSelectColor = textSelectColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    public void setBgColor(int bgUsualColor, int bgSelectColor, int bgHoverColor) {
        this.setBgUsualColor(bgUsualColor);
        this.setBgSelectColor(bgSelectColor);
        this.setBgHoverColor(bgHoverColor);
    }

    public void setBgUsualColor(int bgUsualColor) {
        this.bgUsualColor = bgUsualColor;
    }

    public void setBgSelectColor(int bgSelectColor) {
        this.bgSelectColor = bgSelectColor;
    }

    public void setBgHoverColor(int bgHoverColor) {
        this.bgHoverColor = bgHoverColor;
    }

    public boolean isInWidget(double pMouseX, double pMouseY) {
        return pMouseX > (double)this.getX() && pMouseX < (double)(this.getX() + this.width) && pMouseY > (double)this.getY() && pMouseY < (double)(this.getY() + this.height);
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void drawStr(GuiGraphics guiGraphics, Component component, int x, int y, int color) {
        guiGraphics.drawString(this.font, component, x, y, color, this.textShadow);
    }

    protected abstract void renderWidget(GuiGraphics var1, int var2, int var3, float var4);

    protected abstract void updateWidgetNarration(NarrationElementOutput var1);
}

