/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.math._Math;
import dev.anye.mc.cores.am.color.ColorSchemes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderWidgetCore<T extends RenderWidgetCore<T>>
extends AbstractWidget
implements Renderable {
    protected Font font;
    protected int messageWidth;
    protected int singleCharacterWidth;
    protected int textUsualColor;
    protected int textHoverColor;
    protected int textSelectColor;
    protected int backgroundUsualColor;
    protected int backgroundHoverColor;
    protected int backgroundSelectColor;
    protected _ColorScheme.Color textColor;
    protected _ColorScheme.Color backgroundColor;
    protected _ColorScheme.Color borderColor;
    protected _ColorScheme.Color eBorderColor;
    protected _ColorScheme.Color eTextColor;
    protected _ColorScheme.Color eBackgroundColor;
    protected int layerZ = 1000;
    protected int halfFontLine;
    protected List<Component> customToolTip = new ArrayList<Component>();

    public RenderWidgetCore(int x, int y, int w, int h, Component pMessage) {
        this(Minecraft.getInstance().font, x, y, w, h, pMessage);
    }

    public RenderWidgetCore(Font font, int x, int y, int w, int h, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setFont(font);
        this.setColorScheme(ColorSchemes.getGlobal());
    }

    public _ColorScheme colorScheme() {
        return ColorSchemes.getGlobal();
    }

    public T setColorScheme(_ColorScheme colorScheme) {
        this.textColor = colorScheme.getColor("text");
        this.textHoverColor = this.textColor.HoverColor();
        this.textUsualColor = this.textColor.UsualColor();
        this.textSelectColor = this.textColor.SelectColor();
        this.backgroundColor = colorScheme.getColor("background");
        this.backgroundHoverColor = this.backgroundColor.HoverColor();
        this.backgroundUsualColor = this.backgroundColor.UsualColor();
        this.backgroundSelectColor = this.backgroundColor.SelectColor();
        this.borderColor = colorScheme.getColor("border");
        this.eBorderColor = colorScheme.getColor("element_border");
        this.eTextColor = colorScheme.getColor("element_text");
        this.eBackgroundColor = colorScheme.getColor("element_background");
        return this.self();
    }

    protected T self() {
        return (T)((Object)this);
    }

    public Font getFont() {
        return this.font;
    }

    public T setFont(Font font) {
        this.font = font;
        this.setMessageWidth();
        this.setSingleCharacterWidth();
        Objects.requireNonNull(font);
        this.halfFontLine = _Math.half((int)9);
        return this.self();
    }

    public int getMessageWidth() {
        return this.messageWidth;
    }

    public T setMessageWidth() {
        this.messageWidth = this.font.width((FormattedText)this.getMessage());
        return this.self();
    }

    public int getSingleCharacterWidth() {
        return this.singleCharacterWidth;
    }

    public T setSingleCharacterWidth() {
        this.singleCharacterWidth = this.getFont().width("a");
        return this.self();
    }

    public int getLayerZ() {
        return this.layerZ;
    }

    public T setLayerZ(int layerZ) {
        this.layerZ = layerZ;
        return this.self();
    }

    public int getBackgroundUsualColor() {
        return this.backgroundUsualColor;
    }

    public T setBackgroundUsualColor(int backgroundUsualColor) {
        this.backgroundUsualColor = backgroundUsualColor;
        return this.self();
    }

    public int getBackgroundHoverColor() {
        return this.backgroundHoverColor;
    }

    public T setBackgroundHoverColor(int backgroundHoverColor) {
        this.backgroundHoverColor = backgroundHoverColor;
        return this.self();
    }

    public int getTextUsualColor() {
        return this.textUsualColor;
    }

    public void setTextUsualColor(int textUsualColor) {
        this.textUsualColor = textUsualColor;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    protected void drawString(GuiGraphics guiGraphics, Font font, int x, int y, int color, boolean shadow, Component component) {
        guiGraphics.drawString(font, component, x, y, color, shadow);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, boolean shadow, Component component) {
        this.drawString(guiGraphics, this.font, x, y, color, shadow, component);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, Component component) {
        this.drawString(guiGraphics, this.font, x, y, color, false, component);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, String s) {
        this.drawString(guiGraphics, this.font, x, y, color, false, (Component)Component.literal((String)s));
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, Component component) {
        this.drawString(guiGraphics, this.font, x, y, this.backgroundUsualColor, false, component);
    }

    public void setCustomToolTip(List<Component> customToolTip) {
        this.customToolTip = customToolTip;
    }

    public List<Component> getCustomTooltip() {
        return this.customToolTip;
    }

    protected abstract void renderWidget(GuiGraphics var1, int var2, int var3, float var4);

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress();
    }
}

