/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RouletteMenu
extends RenderWidgetCore<RouletteMenu> {
    private int sectors = 9;
    private int outerRadius = 80;
    private int highlightColor = 1348756580;
    private int normalColor = 1351190921;
    private double addAngle = Math.PI / (double)(5 * this.outerRadius);

    public RouletteMenu(int x, int y, int w, int h, Component pMessage) {
        super(x, y, w, h, pMessage);
    }

    public void setAddAngle(double addAngle) {
        this.addAngle = addAngle;
    }

    public void setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setNormalColor(int normalColor) {
        this.normalColor = normalColor;
    }

    public void setOuterRadius(int outerRadius) {
        this.outerRadius = outerRadius;
    }

    public void setSectors(int sectors) {
        this.sectors = sectors;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.visible) {
            int centerX = this.getX();
            int centerY = this.getY();
            double angle = Math.atan2(mouseY - centerY, mouseX - centerX);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            double sectorAngle = Math.PI * 2 / (double)this.sectors;
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex((float)centerX, (float)centerY, 0.0f).setColor(this.normalColor);
            for (int i = 0; i < this.sectors; ++i) {
                double startAngle = (double)i * sectorAngle;
                double endAngle = (double)(i + 1) * sectorAngle;
                int bgColor = angle >= startAngle && angle < endAngle ? this.highlightColor : this.normalColor;
                for (double a = startAngle; a < endAngle; a += Math.PI / 180) {
                    float x2 = (float)((double)centerX + Math.cos(a) * (double)this.outerRadius);
                    float y2 = (float)((double)centerY + Math.sin(a) * (double)this.outerRadius);
                    buffer.addVertex(x2, y2, 0.0f).setColor(bgColor);
                }
            }
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
    }
}

