/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.c;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.screen.bs.BorderStyle;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class CWidgetBaseCore<T extends CWidgetBaseCore<T>>
extends RenderWidgetCore<T> {
    protected final _BoundingBox boundingBox;
    protected _BoundingBox contentBox = new _BoundingBox(0, 0, 0, 0);
    protected final BorderStyle borderStyle;

    public CWidgetBaseCore(_BoundingBox boundingBox, BorderStyle borderStyle, Component pMessage) {
        super(boundingBox.getX(), boundingBox.getY(), boundingBox.getW(), boundingBox.getH(), pMessage);
        this.boundingBox = boundingBox;
        this.borderStyle = borderStyle;
    }

    @Override
    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            PoseStack poseStack = pGuiGraphics.pose();
            this.contentBox = this.boundingBox.copy();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, (float)this.layerZ);
            this.borderStyle.render(pGuiGraphics, this.contentBox, this.colorScheme(), pMouseX, pMouseY);
            this.renderContent(pGuiGraphics, this.contentBox, pMouseX, pMouseY, pPartialTick);
            poseStack.popPose();
        }
    }

    protected abstract void renderContent(GuiGraphics var1, _BoundingBox var2, int var3, int var4, float var5);

    public static _BoundingBox AutoWidth(_BoundingBox boundingBox, String s, int offset) {
        boundingBox.setW(Minecraft.getInstance().font.width(s) + offset);
        return boundingBox;
    }

    public int CenterY(int y, int h) {
        Objects.requireNonNull(this.font);
        return y + (h - 9 >> 1) + 1;
    }

    public int CenterX(int x, int w) {
        return x + (w - this.font.width((FormattedText)this.getMessage()) >> 1);
    }
}

