/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.c;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.anye.core.debug._DeBug;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.screen.bs.BorderStyle;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.c.CWidgetBaseCore;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class CWidgetDropDownSelectBox
extends CWidgetBaseCore<CWidgetDropDownSelectBox> {
    private final List<DT_ListBoxData> dataList;
    private int nowSelectIndex = -1;
    private int lineHeight;
    private int nowPage;
    private boolean showList = false;
    private final int line;
    private final int pages;
    private final boolean center;
    private int elementH;

    public CWidgetDropDownSelectBox(_BoundingBox boundingBox, BorderStyle borderStyle, Component pMessage, int line, boolean center, DT_ListBoxData ... data2) {
        this(boundingBox, borderStyle, pMessage, line, center, Arrays.asList(data2));
    }

    public CWidgetDropDownSelectBox(_BoundingBox boundingBox, BorderStyle borderStyle, Component pMessage, int line, boolean center, List<DT_ListBoxData> data2) {
        super(boundingBox, borderStyle, pMessage);
        this.dataList = data2;
        this.center = center;
        this.line = line;
        this.lineHeight = 0;
        this.pages = this.getPages(this.dataList.size(), line);
        this.nowPage = 1;
    }

    public int dataSize() {
        return this.dataList.size();
    }

    public int getPages(int number, int line) {
        if (number == 0) {
            return 1;
        }
        int n = number / line;
        if (number % line != 0) {
            ++n;
        }
        return n;
    }

    public int getNowPage() {
        return this.nowPage;
    }

    public void setNowPage(int nowPage) {
        this.nowPage = nowPage;
    }

    public Component getSelectComponent() {
        DT_ListBoxData dropDownListBoxData = this.getSelectData();
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"--");
    }

    public Component getComponent(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"--");
    }

    public List<Component> getDataTooltip(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getTooltip();
        }
        return List.of(Component.literal((String)"--"));
    }

    public DT_ListBoxData getSelectData() {
        if (this.nowSelectIndex >= 0 && this.nowSelectIndex < this.dataList.size()) {
            return this.dataList.get(this.nowSelectIndex);
        }
        return null;
    }

    public DT_ListBoxData getData(int index) {
        int i = (this.getNowPage() - 1) * this.line + index;
        if (i >= 0 && i < this.dataList.size()) {
            return this.dataList.get(i);
        }
        return null;
    }

    public Object getSelectValue() {
        if (this.nowSelectIndex > this.dataList.size() || this.nowSelectIndex < 0) {
            _DeBug.ThrowError((String)"Error Select");
            return null;
        }
        return this.dataList.get(this.nowSelectIndex).getValue();
    }

    public boolean setSelect(int index) {
        if (index > this.dataList.size() || index < 0) {
            return false;
        }
        this.nowSelectIndex = index;
        return true;
    }

    public int getNowSelectIndex() {
        return this.nowSelectIndex;
    }

    public String FixStrWidth(String s) {
        return this.font.plainSubstrByWidth(s, this.width);
    }

    public String FixStrWidth(Component s) {
        return this.FixStrWidth(s.getString());
    }

    public void onClick(double pMouseX, double pMouseY, int button) {
        this.showList = !this.showList;
        int np = this.getNowPage();
        if (this.showList) {
            this.setHeight(this.boundingBox.getH() + this.lineHeight);
        } else {
            this.setHeight(this.boundingBox.getH());
        }
        this.updateIndex(pMouseY, np);
    }

    public void updateIndex(double mouseY, int page) {
        int i = (int)((mouseY - (double)this.contentBox.getY()) / (double)this.elementH);
        if (i > 0) {
            this.nowSelectIndex = i - 1;
            this.nowSelectIndex += (page - 1) * this.line;
            DT_ListBoxData dropDownListBoxData = this.getSelectData();
            if (dropDownListBoxData != null) {
                dropDownListBoxData.OnPress(this.getSelectValue());
            }
        }
    }

    public boolean isInWidget(double pMouseX, double pMouseY) {
        return this.contentBox.isInBox((int)pMouseX, (int)pMouseY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (this.showList && this.isInWidget(pMouseX, pMouseY)) {
            if (sy < 0.0 && this.getNowPage() < this.pages) {
                this.setNowPage(this.getNowPage() + 1);
            } else if (sy > 0.0 && this.getNowPage() > 1) {
                this.setNowPage(this.getNowPage() - 1);
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    @Override
    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            PoseStack poseStack = pGuiGraphics.pose();
            this.contentBox = this.showList ? new _BoundingBox(this.boundingBox.getX(), this.boundingBox.getY(), this.boundingBox.getW(), this.boundingBox.getH() + this.lineHeight) : this.boundingBox.copy();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, (float)this.layerZ);
            this.borderStyle.render(pGuiGraphics, this.contentBox, this.colorScheme(), pMouseX, pMouseY);
            if (this.lineHeight == 0) {
                this.lineHeight = this.line * this.contentBox.getH();
            }
            this.renderContentX(pGuiGraphics, this.contentBox, pMouseX, pMouseY, pPartialTick);
            poseStack.popPose();
        }
    }

    protected void renderContentX(GuiGraphics guiGraphics, _BoundingBox boundingBox, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Component c = this.getMessage();
        if (this.nowSelectIndex > -1 || c.equals((Object)Component.empty())) {
            c = this.getSelectComponent();
        }
        this.elementH = this.showList ? boundingBox.getH() / (this.line + 1) : boundingBox.getH();
        int sx = boundingBox.getX();
        int sy = this.center ? this.CenterY(boundingBox.getY(), this.boundingBox.getH() - this.borderStyle.w()) : boundingBox.getY();
        guiGraphics.drawString(this.getFont(), (Component)Component.literal((String)this.FixStrWidth(c)), sx, sy, this.getTextHoverColor(), false);
        if (this.showList) {
            for (int i = 0; i < this.line; ++i) {
                int lineH = (i + 1) * this.elementH;
                int lineY = boundingBox.getY() + lineH;
                Component select = this.getComponent(i);
                int tc = this.getTextUsualColor();
                if (mouseX > boundingBox.getX() && mouseX < boundingBox.getMaxX() && mouseY > lineY && mouseY < lineY + this.elementH) {
                    tc = this.textSelectColor;
                    guiGraphics.renderTooltip(this.font, this.getDataTooltip(i), Optional.empty(), mouseX, mouseY);
                    guiGraphics.fill(boundingBox.getX(), lineY, boundingBox.getMaxX(), lineY + this.elementH, this.backgroundSelectColor);
                }
                guiGraphics.drawString(this.getFont(), (Component)Component.literal((String)this.FixStrWidth(select)), sx, sy + lineH, tc, false);
            }
        }
        poseStack.popPose();
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, _BoundingBox boundingBox, int mouseX, int mouseY, float partialTick) {
    }
}

