/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.c;

import dev.anye.core.debug._DeBug;
import dev.anye.core.dt._BoundingBox;
import dev.anye.mc.cores.screen.bs.BorderStyle;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.c.CWidgetBaseCore;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class CWidgetListBox
extends CWidgetBaseCore<CWidgetListBox> {
    protected final List<DT_ListBoxData> data;
    protected final int rowSpace;
    protected final int lineSpace;
    protected final int tRowSpace;
    protected final int tLineSpace;
    protected int line;
    protected int row;
    protected int index;
    protected int startIndex;
    protected int elementalWidth;
    protected int elementalHeight;
    protected int strX = 1;
    protected int strY = 1;

    public CWidgetListBox(_BoundingBox boundingBox, BorderStyle borderStyle, Component pMessage, int row, int line, int rowSpace, int lineSpace, DT_ListBoxData ... data2) {
        this(boundingBox, borderStyle, pMessage, row, line, rowSpace, lineSpace, List.of(data2));
    }

    public CWidgetListBox(_BoundingBox boundingBox, BorderStyle borderStyle, Component pMessage, int row, int line, int rowSpace, int lineSpace, List<DT_ListBoxData> data2) {
        super(boundingBox, borderStyle, pMessage);
        this.rowSpace = rowSpace;
        this.tRowSpace = rowSpace << 1;
        this.lineSpace = lineSpace;
        this.tLineSpace = lineSpace << 1;
        this.data = data2;
        this.row = row;
        this.line = line;
        this.elementalWidth = 0;
        this.elementalHeight = 0;
        this.index = -1;
        this.startIndex = 0;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, _BoundingBox boundingBox, int mouseX, int mouseY, float partialTick) {
        if (this.elementalWidth == 0) {
            this.elementalWidth = boundingBox.getW() / this.row - this.tRowSpace;
        }
        if (this.elementalHeight == 0) {
            this.elementalHeight = boundingBox.getH() / this.line - this.tLineSpace;
        }
        int idex = -1;
        for (int i = 0; i < this.line; ++i) {
            int elemY = boundingBox.getY() + this.tLineSpace + i * (this.elementalHeight + this.tLineSpace) + this.strY;
            for (int r = 0; r < this.row && this.startIndex < this.data.size(); ++r) {
                int elemIndex = this.startIndex + i * this.row + r;
                if (elemIndex >= this.data.size()) continue;
                int elemX = boundingBox.getX() + this.tRowSpace + r * (this.elementalWidth + this.tRowSpace);
                _BoundingBox eb = new _BoundingBox(elemX, elemY, this.elementalWidth, this.elementalHeight);
                this.borderStyle.renderElement(guiGraphics, eb, this.colorScheme(), mouseX, mouseY);
                int txtColor = this.eTextColor.UsualColor();
                if (eb.isInBox(mouseX, mouseY)) {
                    txtColor = this.eTextColor.HoverColor();
                    idex = elemIndex;
                    guiGraphics.renderTooltip(this.font, this.getData(elemIndex).getTooltip(), Optional.empty(), mouseX, mouseY);
                }
                this.drawString(guiGraphics, eb.getX() + this.strX, eb.getY(), txtColor, this.FixStrWidth(this.getDataComponent(elemIndex), eb.getW()));
            }
        }
        this.index = idex;
    }

    public DT_ListBoxData getData(int index) {
        if (index < this.data.size()) {
            return this.data.get(index);
        }
        _DeBug.ThrowError((String)"error index");
        return null;
    }

    public Component getDataComponent(int index) {
        DT_ListBoxData d = this.getData(index);
        if (d != null) {
            return d.getComponent();
        }
        _DeBug.ThrowError((String)"error data");
        return Component.literal((String)"Error :: Null");
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (sy < 0.0 && this.startIndex < this.data.size() - this.row) {
            this.startIndex += this.row;
        } else if (this.startIndex >= this.row) {
            this.startIndex -= this.row;
        }
        this.index = -1;
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    public void onClick(double pMouseX, double pMouseY, int button) {
        DT_ListBoxData d;
        if (this.isMouseOver(pMouseX, pMouseY) && this.index >= 0 && (d = this.getData(this.index)) != null) {
            d.OnPress(d.getValue());
        }
    }

    public String FixStrWidth(String s, int w) {
        return this.font.plainSubstrByWidth(s, w);
    }

    public String FixStrWidth(Component s, int w) {
        return this.FixStrWidth(s.getString(), w);
    }
}

