/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.core.math._Math;
import dev.anye.mc.cores.screen.widget.simple.SimpleWidgetCore;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleLabel
extends SimpleWidgetCore<SimpleLabel> {
    private int drawX;
    private int drawY;
    private boolean AutoWidth;
    private boolean AutoHeight;
    private boolean centerText;

    public SimpleLabel(int x, int y, int w, int h, Component pMessage, int borderColor, int fillColor, int textColor, boolean AutoWidth, boolean AutoHeight, boolean centerText) {
        super(x, y, w, h, pMessage);
        this.setAutoWidth(AutoWidth);
        this.setAutoHeight(AutoHeight);
        this.setCenterText(centerText);
        this.setBorderUsualColor(borderColor);
        this.setBorderHoverColor(borderColor);
        this.setBackgroundHoverColor(fillColor);
        this.setBackgroundUsualColor(fillColor);
        this.setTextUsualColor(textColor);
        this.setTextHoverColor(textColor);
    }

    public SimpleLabel(int x, int y, int w, int h, Component pMessage, boolean AutoWidth, boolean AutoHeight, boolean centerText) {
        super(x, y, w, h, pMessage);
        this.setAutoWidth(AutoWidth);
        this.setAutoHeight(AutoHeight);
        this.setCenterText(centerText);
    }

    public SimpleLabel(int x, int y, int w, int h, Component pMessage, int borderColor, int fillColor, int textColor, boolean AutoWidth, boolean AutoHeight) {
        this(x, y, w, h, pMessage, borderColor, fillColor, textColor, AutoWidth, AutoHeight, false);
    }

    public SimpleLabel(int x, int y, int w, int h, Component pMessage, int borderColor, int fillColor, int textColor, boolean AutoWidth) {
        this(x, y, w, h, pMessage, borderColor, fillColor, textColor, AutoWidth, false);
    }

    public SimpleLabel(int x, int y, int w, int h, Component pMessage, int borderColor, int fillColor, int textColor) {
        this(x, y, w, h, pMessage, borderColor, fillColor, textColor, true);
    }

    public void setMessage(Component pMessage) {
        super.setMessage(pMessage);
        this.setAutoWidth(this.isAutoWidth());
    }

    public boolean isAutoWidth() {
        return this.AutoWidth;
    }

    public SimpleLabel setAutoWidth(boolean AutoWidth) {
        this.AutoWidth = AutoWidth;
        if (this.AutoWidth) {
            this.setWidth(this.font.width((FormattedText)this.getMessage()) + this.getRadius() * 2 + 10);
            this.setCenterText(this.centerText);
        }
        return this;
    }

    public boolean isAutoHeight() {
        return this.AutoHeight;
    }

    public SimpleLabel setAutoHeight(boolean autoHeight) {
        this.AutoHeight = autoHeight;
        if (this.AutoHeight) {
            Objects.requireNonNull(this.font);
            this.setHeight(9 + this.getRadius() * 2 + 4);
            this.setCenterText(this.centerText);
        }
        return this;
    }

    public boolean isCenterText() {
        return this.centerText;
    }

    public SimpleLabel setCenterText(boolean centerText) {
        this.centerText = centerText;
        if (this.centerText) {
            this.setDrawX(this.getContentX() + _Math.half((int)this.getContentW()));
            int n = this.getContentY() + _Math.half((int)this.getContentH());
            Objects.requireNonNull(this.font);
            this.setDrawY(n - _Math.half((int)9));
        } else {
            this.setDrawX(this.getContentX());
            this.setDrawY(this.getContentY());
        }
        return this;
    }

    public SimpleLabel setDrawX(int drawX) {
        this.drawX = drawX;
        return this;
    }

    public int getDrawX() {
        return this.drawX;
    }

    public SimpleLabel setDrawY(int drawY) {
        this.drawY = drawY;
        return this;
    }

    public int getDrawY() {
        return this.drawY;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int tc = this.getTextUsualColor();
        if (this.isMouseOver(pMouseX, pMouseY)) {
            tc = this.getTextHoverColor();
            if (this.getCustomTooltip() != null) {
                guiGraphics.renderComponentTooltip(this.getFont(), this.getCustomTooltip(), pMouseX, pMouseY);
            }
        }
        if (this.isCenterText()) {
            guiGraphics.drawString(this.font, this.getMessage(), this.getDrawX() - _Math.half((int)this.font.width((FormattedText)this.getMessage())), this.getDrawY(), tc, false);
        } else {
            guiGraphics.drawString(this.font, this.getMessage(), this.getDrawX(), this.getDrawY(), tc, false);
        }
    }
}

