/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.mc.cores.screen.widget.simple.SimpleWidgetCore;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleProgressBar
extends SimpleWidgetCore<SimpleProgressBar> {
    protected int progress;
    protected int maxProgress;
    protected int direction;

    public SimpleProgressBar(int x, int y, int w, int h, int progress, int maxProgress, int direction, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.direction = direction;
        this.setProgress(progress);
        this.setMaxProgress(maxProgress);
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int i, int i1, float v) {
        int endX = this.getContentEndX();
        int endY = this.getContentEndY();
        if (this.direction == 0) {
            endX = this.getContentX() + this.getScaleProgress(this.getContentW());
        } else if (this.direction == 1) {
            endY = this.getContentY() + this.getScaleProgress(this.getContentH());
        }
        guiGraphics.fill(this.getContentX(), this.getContentY(), endX, endY, this.getBorderHoverColor());
    }

    public int getScaleProgress(int i) {
        return this.maxProgress != 0 && this.progress != 0 ? this.progress * i / this.maxProgress : 0;
    }
}

