/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.mc.cores.render.DrawSector;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class SimpleWidgetCore<T extends SimpleWidgetCore<T>>
extends RenderWidgetCore<T> {
    protected int radius;
    protected int borderUsualColor;
    protected int borderHoverColor;
    protected int borderSelectColor;
    protected int contentX;
    protected int contentY;
    protected int contentW;
    protected int contentH;
    protected int contentEndX;
    protected int contentEndY;

    protected SimpleWidgetCore(int x, int y, int w, int h, Component pMessage) {
        this(x, y, w, h, 2, pMessage);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int r, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setRadius(r);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int radius, int borderUsualColor, int borderHoverColor, int textUsualColor, int textHoverColor, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setTextUsualColor(textUsualColor);
        this.setTextHoverColor(textHoverColor);
        this.setBorderUsualColor(borderUsualColor);
        this.setBorderHoverColor(borderHoverColor);
        this.setRadius(radius);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int radius, int borderUsualColor, int borderHoverColor, int textUsualColor, int textHoverColor, int backgroundUsualColor, int backgroundHoverColor, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setTextUsualColor(textUsualColor);
        this.setTextHoverColor(textHoverColor);
        this.setBorderUsualColor(borderUsualColor);
        this.setBorderHoverColor(borderHoverColor);
        this.setBackgroundUsualColor(backgroundUsualColor);
        this.setBackgroundHoverColor(backgroundHoverColor);
        this.setRadius(radius);
    }

    @Override
    public T setColorScheme(_ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        this.setBorderUsualColor(colorScheme.getColor("border").UsualColor());
        this.setBorderHoverColor(colorScheme.getColor("border").HoverColor());
        this.setBorderSelectColor(colorScheme.getColor("border").SelectColor());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public void setWidth(int pWidth) {
        super.setWidth(pWidth);
        this.setRadius(this.getRadius());
    }

    public void setHeight(int pHeight) {
        super.setHeight(pHeight);
        this.setRadius(this.getRadius());
    }

    public T setBorderSelectColor(int borderSelectColor) {
        this.borderSelectColor = borderSelectColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public T setBorderUsualColor(int borderUsualColor) {
        this.borderUsualColor = borderUsualColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getBorderUsualColor() {
        return this.borderUsualColor;
    }

    public T setBorderHoverColor(int borderHoverColor) {
        this.borderHoverColor = borderHoverColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getBorderHoverColor() {
        return this.borderHoverColor;
    }

    public T setRadius(int radius) {
        this.radius = radius;
        this.setContentX(this.getX() + radius);
        this.setContentY(this.getY() + radius);
        this.setContentH(this.getHeight() - 2 * radius);
        this.setContentW(this.getWidth() - 2 * radius);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getRadius() {
        return this.radius;
    }

    public T setContentH(int contentH) {
        this.contentH = contentH;
        this.setContentEndY(this.getContentY() + this.contentH);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentH() {
        return this.contentH;
    }

    public T setContentW(int contentW) {
        this.contentW = contentW;
        this.setContentEndX(this.getContentX() + this.contentW);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentW() {
        return this.contentW;
    }

    public T setContentX(int contentX) {
        this.contentX = contentX;
        this.setContentEndX(this.contentX + this.getContentW());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentX() {
        return this.contentX;
    }

    public T setContentY(int contentY) {
        this.contentY = contentY;
        this.setContentEndY(this.contentY + this.getContentH());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentY() {
        return this.contentY;
    }

    public T setContentEndX(int contentEndX) {
        this.contentEndX = contentEndX;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentEndX() {
        return this.contentEndX;
    }

    public T setContentEndY(int contentEndY) {
        this.contentEndY = contentEndY;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentEndY() {
        return this.contentEndY;
    }

    protected void renderShape(PoseStack poseStack, int borderColor, int fillColor) {
        this.renderShape(poseStack, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getRadius(), borderColor, fillColor);
    }

    protected void renderShape(PoseStack poseStack, int x, int y, int width, int height, int radius, int borderColor, int fillColor) {
        this.drawRoundedRect(poseStack, x, y, width, height, radius, borderColor, fillColor);
    }

    protected void drawRoundedRect(PoseStack poseStack, int x, int y, int width, int height, int radius, int borderColor, int fillColor) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        this.addVertex(buffer, matrix, x + radius, y + radius, fillColor);
        this.addVertex(buffer, matrix, x + width - radius, y + radius, fillColor);
        this.addVertex(buffer, matrix, x + width - radius, y + height - radius, fillColor);
        this.addVertex(buffer, matrix, x + radius, y + height - radius, fillColor);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        poseStack.pushPose();
        matrix = poseStack.last().pose();
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        this.drawBorder(buffer, matrix, x, y, width, height, radius, borderColor);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        this.drawCorners(poseStack, x, y, width, height, radius, borderColor);
        RenderSystem.disableBlend();
    }

    protected void drawBorder(BufferBuilder buffer, Matrix4f matrix, int x, int y, int width, int height, int radius, int borderColor) {
        this.addVertex(buffer, matrix, x + radius, y, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + radius, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + radius, y + height - radius, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y + height - radius, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y + height, borderColor);
        this.addVertex(buffer, matrix, x + radius, y + height, borderColor);
        this.addVertex(buffer, matrix, x, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + radius, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + radius, y + height - radius, borderColor);
        this.addVertex(buffer, matrix, x, y + height - radius, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + width, y + radius, borderColor);
        this.addVertex(buffer, matrix, x + width, y + height - radius, borderColor);
        this.addVertex(buffer, matrix, x + width - radius, y + height - radius, borderColor);
    }

    protected void drawCorners(PoseStack poseStack, int x, int y, int width, int height, int radius, int color) {
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.translate((float)radius, (float)radius, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, Math.PI, 4.71238898038469, color);
        poseStack.translate((float)(width - 2 * radius), 0.0f, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 4.71238898038469, Math.PI * 2, color);
        poseStack.translate(0.0f, (float)(height - 2 * radius), 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 0.0, 1.5707963267948966, color);
        poseStack.translate((float)(-(width - 2 * radius)), 0.0f, 0.0f);
        DrawSector.draw(poseStack.last().pose(), 0, radius, 1.5707963267948966, Math.PI, color);
        poseStack.popPose();
    }

    protected void addVertex(BufferBuilder buffer, int x, int y, int color) {
        buffer.addVertex((float)x, (float)y, 0.0f).setColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    protected void addVertex(BufferBuilder buffer, Matrix4f matrix, int x, int y, int color) {
        buffer.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    @Override
    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            int borderColor = this.getBorderUsualColor();
            int fillColor = this.getBackgroundUsualColor();
            if (this.isMouseOver(pMouseX, pMouseY)) {
                borderColor = this.getBorderHoverColor();
                fillColor = this.getBackgroundHoverColor();
            }
            PoseStack poseStack = pGuiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, (float)this.layerZ);
            this.renderShape(poseStack, borderColor, fillColor);
            this.renderContent(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            poseStack.popPose();
        }
    }

    protected abstract void renderContent(GuiGraphics var1, int var2, int var3, float var4);
}

