/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.square;

import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import dev.anye.mc.cores.screen.widget.square.SquareWidgetCore;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SquareButton
extends SquareWidgetCore<SquareButton> {
    private final RenderWidgetCore.OnPress onPress;
    protected int textUsualColor;
    protected int textSelectColor;
    private int dx;
    private int dy;

    public SquareButton(int x, int y, int w, int h, Component pMessage, RenderWidgetCore.OnPress onPress) {
        super(x, y, w, h, pMessage);
        this.dx = this.getX() + this.width / 2;
        int n = this.getY() + this.height / 2;
        Objects.requireNonNull(this.font);
        this.dy = n - 9 / 2;
        this.onPress = onPress;
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    public void setDy(int dy) {
        this.dy = dy;
    }

    public void setTextSelectColor(int textSelectColor) {
        this.textSelectColor = textSelectColor;
    }

    @Override
    public void setTextUsualColor(int textUsualColor) {
        this.textUsualColor = textUsualColor;
    }

    public void onClick(double pMouseX, double pMouseY) {
        this.onPress.onPress();
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.drawSquare(guiGraphics, this.backgroundHoverColor);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.drawCenteredString(this.font, this.getMessage(), this.dx, this.dy, this.textSelectColor);
            guiGraphics.renderTooltip(this.font, this.getMessage(), mouseX, mouseY);
        } else {
            this.drawSquare(guiGraphics, this.backgroundUsualColor);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.drawCenteredString(this.font, this.getMessage(), this.dx, this.dy, this.textUsualColor);
        }
    }
}

