/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.square;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.anye.core.color._ColorCDT;
import dev.anye.core.debug._DeBug;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.DT_XYWHUV;
import dev.anye.mc.cores.screen.widget.square.SquareWidgetCore;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SquareListBox
extends SquareWidgetCore<SquareListBox> {
    private List<DT_ListBoxData> data;
    private int dataSize;
    private int line;
    private int row;
    private int index;
    private int startIndex;
    private int elementalWidth;
    private int elementalHeight;
    private int hSpace;
    private int vSpace;
    private DT_XYWHUV bg;
    private int bgColor;
    private int textSelectColor;
    private int textColor;
    private int left = 0;
    private int top = 0;
    private int strX;
    private int strY;

    public SquareListBox(int x, int y, int w, int h, int elementalWidth, int elementalHeight, Component pMessage, List<DT_ListBoxData> data2) {
        super(x, y, w, h, pMessage);
        this.data = data2;
        this.dataSize = this.data.size();
        this.elementalWidth = elementalWidth;
        this.elementalHeight = elementalHeight;
        this.index = -1;
        this.startIndex = 0;
        this.bgColor = _ColorCDT.black;
        this.textColor = _ColorCDT.white;
        this.textSelectColor = _ColorCDT.yellow;
        this.resetAutoSpace();
        this.setStrY();
    }

    public void setData(List<DT_ListBoxData> data2) {
        this.data = data2;
        this.dataSize = this.data.size();
        this.index = -1;
        this.startIndex = 0;
    }

    public void setTop(int top) {
        this.top = top;
    }

    @Override
    public SquareListBox setFont(Font font) {
        super.setFont(font);
        this.setStrY();
        return (SquareListBox)((Object)this.self());
    }

    public void setLeft(int left) {
        this.left = left;
        this.resetAutoSpace();
    }

    public void resetAutoSpace() {
        double s = this.elementalWidth % (this.width - this.left);
        s /= (double)(this.width - this.left) / (double)this.elementalWidth;
        this.setVSpace((int)(s /= 2.0));
        this.setHSpace((int)s);
    }

    public void setBg(DT_XYWHUV bg) {
        this.bg = bg;
    }

    public void setStrY() {
        Objects.requireNonNull(this.font);
        this.strY = this.elementalWidth / 9 / 2;
    }

    public void setElementalHeight(int elementalHeight) {
        this.elementalHeight = elementalHeight;
    }

    public void setElementalWidth(int elementalWidth) {
        this.elementalWidth = elementalWidth;
    }

    public void setVSpace(int vSpace) {
        this.vSpace = vSpace;
        this.line = this.getHeight() / (this.elementalHeight + vSpace);
    }

    public void setHSpace(int hSpace) {
        this.hSpace = hSpace;
        this.row = this.getWidth() / (this.elementalWidth + hSpace);
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextSelectColor(int textSelectColor) {
        this.textSelectColor = textSelectColor;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, (float)this.layerZ);
        int idex = -1;
        this.drawSquare(guiGraphics, this.bgColor);
        for (int i = 0; i < this.line; ++i) {
            int dy = this.left + this.getY() + i * (this.elementalHeight + this.vSpace);
            for (int r = 0; r < this.row && this.startIndex < this.dataSize; ++r) {
                int ni = this.startIndex + i * this.row + r;
                if (ni >= this.dataSize) continue;
                int dx = this.top + this.getX() + r * (this.elementalWidth + this.hSpace);
                int bgc = this.backgroundUsualColor;
                int tc = this.textColor;
                if (mouseX > dx && mouseX < dx + this.elementalWidth && mouseY > dy && mouseY < dy + this.elementalHeight) {
                    bgc = this.backgroundHoverColor;
                    tc = this.textSelectColor;
                    idex = ni;
                    guiGraphics.renderTooltip(this.font, this.getData(ni).getTooltip(), Optional.empty(), mouseX, mouseY);
                }
                this.drawSquare(guiGraphics, dx, dy, this.elementalWidth, this.elementalHeight, bgc);
                this.drawString(guiGraphics, dx, dy + this.strY, tc, this.FixStrWidth(this.getDataComponent(ni)));
            }
        }
        this.index = idex;
        poseStack.popPose();
    }

    public DT_ListBoxData getData(int index) {
        if (index < this.data.size()) {
            return this.data.get(index);
        }
        _DeBug.ThrowError((String)"error index");
        return null;
    }

    public Component getDataComponent(int index) {
        DT_ListBoxData d = this.getData(index);
        if (d != null) {
            return d.getComponent();
        }
        _DeBug.ThrowError((String)"error data");
        return Component.literal((String)"Error :: Null");
    }

    public boolean isSelectElemental(int pMouseX, int pMouseY) {
        if (this.index < 0) {
            return false;
        }
        return pMouseX > this.getX() + (this.index - 1) * (this.elementalWidth + this.hSpace) && pMouseX < this.getX() + (this.elementalWidth + this.hSpace) * this.index && pMouseY > this.getY() + (this.elementalHeight + this.vSpace) * (this.index - 1) && pMouseY < this.getY() + (this.elementalHeight + this.vSpace) * this.index;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (sy < 0.0 && this.startIndex < this.dataSize - this.row) {
            this.startIndex += this.row;
        } else if (this.startIndex >= this.row) {
            this.startIndex -= this.row;
        }
        this.index = -1;
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    public void onClick(double pMouseX, double pMouseY) {
        DT_ListBoxData d;
        if (this.isMouseOver(pMouseX, pMouseY) && this.index >= 0 && (d = this.getData(this.index)) != null) {
            d.OnPress(d.getValue());
        }
    }

    public String FixStrWidth(String s) {
        return this.font.plainSubstrByWidth(s, this.elementalWidth);
    }

    public String FixStrWidth(Component s) {
        return this.FixStrWidth(s.getString());
    }
}

