/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores;

import com.google.common.reflect.TypeToken;
import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.mc.cores.am.color.ColorConfig;
import dev.anye.mc.cores.am.color.ColorConfigData;
import dev.anye.mc.cores.am.color.ColorSchemeRegister;
import dev.anye.mc.cores.am.color.ColorSchemes;
import dev.anye.mc.cores.am.util.KeyBinding;
import dev.anye.mc.cores.cr.CoresRegs;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;

@Mod(value="cores", dist={Dist.CLIENT})
@EventBusSubscriber(modid="cores", value={Dist.CLIENT})
public class CoresClient {
    public static final ContextKey<Entity> RenderStateEntityKey = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"cores", (String)"entity"));

    public CoresClient(ModContainer container) {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        String scheme = ((ColorConfigData)ColorConfig.instance.getDatas()).getColorScheme();
        ResourceLocation colorSchemeRes = ResourceLocation.tryParse((String)scheme);
        if (colorSchemeRes != null && ColorSchemeRegister.REGISTRY.get(colorSchemeRes).isPresent()) {
            _ColorScheme colorScheme = (_ColorScheme)((Holder.Reference)ColorSchemeRegister.REGISTRY.get(colorSchemeRes).get()).value();
            ColorSchemes.setGlobal(colorScheme);
        }
    }

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(KeyBinding.OPEN_MENU);
    }

    @SubscribeEvent
    public static void onRegRenderState(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier((TypeToken)new TypeToken<EntityRenderer<? extends Entity, ? extends EntityRenderState>>(){}, (entity, renderState) -> renderState.setRenderData(RenderStateEntityKey, entity));
    }

    @SubscribeEvent
    public static void onRender(RenderLivingEvent.Post<LivingEntity, ?, ?> event) {
        Object object = event.getRenderState().getRenderData(RenderStateEntityKey);
        if (object instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            CoresRegs.ENTITY_RENDER_REG.forEach((s, iEntityRender) -> iEntityRender.render(livingEntity, event.getRenderState(), event.getRenderer(), event.getSubmitNodeCollector(), event.getPoseStack()));
        }
    }
}

