/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.helper.component;

import dev.anye.core.math._Math;
import dev.anye.mc.cores.helper.component.ComponentStyleCDT;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class ComponentStyle
extends ComponentStyleCDT {
    public static Style getColorStyle(TextColor textColor) {
        return Style.EMPTY.withColor(textColor);
    }

    public static Style getTextColorStyle(int colorsIndex, int index) {
        TextColor[] colors = ComponentStyle.getTextColor(colorsIndex);
        if (index > colors.length - 1) {
            Random random = new Random();
            return ComponentStyle.getColorStyle(colors[random.nextInt(colors.length)]);
        }
        return ComponentStyle.getColorStyle(colors[index]);
    }

    public static TextColor[] getTextColor(int colorsIndex) {
        if (colorsIndex == 0) {
            return blackWithWhite;
        }
        if (colorsIndex == 1) {
            return rainbow;
        }
        return new TextColor[-1];
    }

    public static MutableComponent Flash(String str, long time) {
        return ComponentStyle.Flash(str, 1, time);
    }

    public static MutableComponent Flash(String str, int colorIndex, long time) {
        int strlen = str.length();
        MutableComponent put = Component.literal((String)"");
        int index = (int)(time % 21L) / 3;
        if (strlen < 7) {
            return put.append((Component)Component.literal((String)str).withStyle(ComponentStyle.getTextColorStyle(colorIndex, index)));
        }
        for (int i = 0; i < strlen; ++i) {
            int ii = index - i % 7;
            if (ii < 0) {
                ii += 7;
            }
            put.append((Component)Component.literal((String)str.substring(i, i + 1)).withStyle(ComponentStyle.getTextColorStyle(colorIndex, ii)));
        }
        return put;
    }

    public static MutableComponent Fade(String str, int colorIndex) {
        char[] chars = str.toCharArray();
        MutableComponent put = Component.literal((String)"");
        TextColor[] colors = ComponentStyle.getTextColor(colorIndex);
        int i = -1;
        for (char c : chars) {
            i = _Math.maxToZero((int)i, (int)colors.length);
            put.append((Component)Component.literal((String)String.valueOf(c)).withStyle(ComponentStyle.getColorStyle(colors[i])));
        }
        return put;
    }
}

