/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.mixin;

import dev.anye.mc.cores.am.config.MixinConfigs;
import dev.anye.mc.cores.helper.entity.player.PlayerHelper;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Unique
    private boolean cores$notRunGiveLevel = false;
    @Shadow
    private int lastSentExp;

    @Shadow
    public abstract void giveExperiencePoints(int var1);

    @Inject(method={"giveExperienceLevels"}, at={@At(value="HEAD")}, cancellable=true)
    private void cores$giveExperienceLevels$fix(int pLevel, CallbackInfo ci) {
        if (MixinConfigs.EnableFixLevel) {
            StackTraceElement[] stackTrace;
            boolean skip = false;
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                if (stackTraceElement == null || !stackTraceElement.getMethodName().equals("giveExperiencePoints")) continue;
                skip = true;
                break;
            }
            if (!skip) {
                int points = pLevel < 0 ? -PlayerHelper.getExperienceForLevel(-pLevel) : PlayerHelper.getExperienceForLevel(pLevel);
                this.giveExperiencePoints(points);
                this.lastSentExp = -1;
                ci.cancel();
            }
        }
    }
}

