/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.render.element;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;

public record SectorRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2fStack pose, int x, int y, int outerRadius, double startArc, double endArc, int color, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
{
    public static final double ANGLE_RESOLUTION = Math.PI / 180;
    private static final Logger LOGGER = LogUtils.getLogger();

    public SectorRenderState(Matrix3x2fStack pose, int x, int y, int outerRadius, double startArc, double endArc, int color, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) {
        this(RenderPipelines.DEBUG_TRIANGLE_FAN, TextureSetup.noTexture(), pose, x, y, outerRadius, startArc, endArc, color, scissorArea, bounds);
    }

    public void buildVertices(VertexConsumer vertexConsumer) {
        this.pose.pushMatrix();
        this.pose.translate((float)this.x(), (float)this.y());
        double arc = this.endArc - this.startArc;
        vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, 0.0f, 0.0f).setColor(this.color);
        int segments = (int)Math.ceil(Math.abs(arc) / (Math.PI / 180));
        if (segments < 1) {
            segments = 1;
        }
        for (int i = 0; i <= segments; ++i) {
            float currentArc = (float)(this.startArc + arc * (double)i / (double)segments);
            float x = Mth.cos((float)currentArc) * (float)this.outerRadius;
            float y = Mth.sin((float)currentArc) * (float)this.outerRadius;
            vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, x, y).setColor(this.color);
        }
        this.pose.popMatrix();
    }
}

