/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.render.element;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public record SectorXRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2fStack pose, int x, int y, int innerRadiusX, int innerRadiusY, int outerRadiusX, int outerRadiusY, double startArc, double endArc, int color, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
{
    public SectorXRenderState(Matrix3x2fStack pose, int x, int y, int innerRadiusX, int innerRadiusY, int outerRadiusX, int outerRadiusY, double startArc, double endArc, int color, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) {
        this(RenderPipelines.DEBUG_QUADS, TextureSetup.noTexture(), pose, x, y, innerRadiusX, innerRadiusY, outerRadiusX, outerRadiusY, startArc, endArc, color, scissorArea, bounds);
    }

    public void buildVertices(@NotNull VertexConsumer vertexConsumer) {
        this.pose.pushMatrix();
        this.pose.translate((float)this.x, (float)this.y);
        double arc = this.endArc - this.startArc;
        int segments = (int)Math.ceil(Math.abs(arc) / (Math.PI / 180));
        if (segments < 1) {
            segments = 1;
        }
        for (int i = 0; i < segments; ++i) {
            double currentArc = this.startArc + arc * ((double)i / (double)segments);
            double nextArc = this.startArc + arc * ((double)(i + 1) / (double)segments);
            float x1_inner = Mth.cos((float)((float)currentArc)) * (float)this.innerRadiusX;
            float y1_inner = Mth.sin((float)((float)currentArc)) * (float)this.innerRadiusY;
            float x1_outer = Mth.cos((float)((float)currentArc)) * (float)this.outerRadiusX;
            float y1_outer = Mth.sin((float)((float)currentArc)) * (float)this.outerRadiusY;
            float x2_inner = Mth.cos((float)((float)nextArc)) * (float)this.innerRadiusX;
            float y2_inner = Mth.sin((float)((float)nextArc)) * (float)this.innerRadiusY;
            float x2_outer = Mth.cos((float)((float)nextArc)) * (float)this.outerRadiusX;
            float y2_outer = Mth.sin((float)((float)nextArc)) * (float)this.outerRadiusY;
            vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, x1_inner, y1_inner).setColor(this.color);
            vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, x1_outer, y1_outer).setColor(this.color);
            vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, x2_outer, y2_outer).setColor(this.color);
            vertexConsumer.addVertexWith2DPose((Matrix3x2f)this.pose, x2_inner, y2_inner).setColor(this.color);
        }
        this.pose.popMatrix();
    }
}

