/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import dev.anye.core.debug._DeBug;
import dev.anye.mc.cores.render.GuiGraphicsX;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class CircularWidget
extends RenderWidgetCore<CircularWidget> {
    protected FlipMode flipMode;
    protected int sectors;
    protected int innerRadius;
    protected int outerRadius;
    protected double fanAngle;
    protected double fanArc;
    protected double halfFanArc;
    protected List<DT_ListBoxData> data;
    protected int index = -1;
    protected int startIndex = 0;
    protected int fanTextInnerSpace;

    public CircularWidget(int x, int y, int w, int h, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, Component message, List<DT_ListBoxData> data2) {
        this(x, y, w, h, 9, 20, 80, message, data2);
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, List<DT_ListBoxData> data2) {
        super(x, y, w, h, message);
        if (sectors < 1) {
            _DeBug.ThrowError((String)"error sectors");
        }
        this.setData(data2);
        this.setSectors(sectors);
        this.setInnerRadius(innerRadius);
        this.setOuterRadius(outerRadius);
        this.setFlipMode(FlipMode.tire);
        this.setFanTextInnerSpace(10);
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, DT_ListBoxData ... data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, highlightColor, normalColor, message, List.of(data2));
    }

    public CircularWidget(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, List<DT_ListBoxData> data2) {
        this(x, y, w, h, sectors, innerRadius, outerRadius, message, data2);
        this.setBackgroundHoverColor(highlightColor);
        this.setBackgroundUsualColor(normalColor);
    }

    public void setData(List<DT_ListBoxData> data2) {
        this.data = data2;
    }

    public void setFanTextInnerSpace(int fanTextInnerSpace) {
        this.fanTextInnerSpace = fanTextInnerSpace;
    }

    public void setFlipMode(FlipMode flipMode) {
        this.flipMode = flipMode;
    }

    public void setFanArc(double fanArc) {
        this.fanArc = fanArc;
        this.setHalfFanArc(fanArc / 2.0);
    }

    public void setHalfFanArc(double halfFanArc) {
        this.halfFanArc = halfFanArc;
    }

    public int getFanTextInnerSpace() {
        return Math.max(this.fanTextInnerSpace, this.innerRadius);
    }

    public void setFanAngle(double fanAngle) {
        this.fanAngle = fanAngle;
    }

    public void setOuterRadius(int outerRadius) {
        this.outerRadius = outerRadius;
    }

    public void setSectors(int sectors) {
        this.sectors = sectors;
        this.setFanAngle(360.0 / (double)sectors);
        this.setFanArc(Math.PI * 2 / (double)sectors);
    }

    public void setInnerRadius(int innerRadius) {
        this.innerRadius = innerRadius;
    }

    public DT_ListBoxData getData() {
        return this.getData(this.index);
    }

    public DT_ListBoxData getData(int index) {
        if (this.isValidIndex(index)) {
            return this.data.get(index);
        }
        return null;
    }

    public boolean isValidIndex() {
        return this.isValidIndex(this.index);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.data.size();
    }

    public boolean mouseClicked(MouseButtonEvent p_447133_, boolean p_434606_) {
        return this.mouseClicked(p_447133_.x(), p_447133_.y(), p_447133_.button()) || super.mouseClicked(p_447133_, p_434606_);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.active && this.visible && this.flipMode == FlipMode.button) {
            if (pButton == 0) {
                if (this.startIndex >= this.sectors) {
                    this.startIndex -= this.sectors;
                    return true;
                }
            } else if (pButton == 1 && this.data.size() > this.startIndex + this.sectors) {
                this.startIndex += this.sectors;
                return true;
            }
        }
        return false;
    }

    public void onClick(MouseButtonEvent p_446284_, boolean p_434599_) {
        this.onClick(p_446284_.x(), p_446284_.y(), p_446284_.button());
    }

    public void onClick(double pMouseX, double pMouseY, int button) {
        DT_ListBoxData dtListBoxData;
        if (this.flipMode == FlipMode.tire && (dtListBoxData = this.getData()) != null) {
            dtListBoxData.OnPress(dtListBoxData.getValue());
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.flipMode == FlipMode.tire) {
            if (pScrollY > 0.0) {
                if (this.startIndex >= this.sectors) {
                    this.startIndex -= this.sectors;
                    return true;
                }
            } else if (this.data.size() > this.startIndex + this.sectors) {
                this.startIndex += this.sectors;
                return true;
            }
            return false;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.visible) {
            int centerX = this.getX();
            int centerY = this.getY();
            double angle = Math.atan2(mouseY - centerY, mouseX - centerX) + this.halfFanArc;
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            for (int i = 0; i < this.sectors; ++i) {
                int sIndex = this.startIndex + i;
                double startAngle = (double)i * this.fanArc;
                double endAngle = (double)(i + 1) * this.fanArc;
                int bgc = this.getBackgroundUsualColor();
                int tc = this.getTextUsualColor();
                float size = 1.0f;
                if (angle >= startAngle && angle < endAngle) {
                    bgc = this.getBackgroundHoverColor();
                    tc = this.getTextHoverColor();
                    size = 1.3f;
                    this.index = sIndex;
                }
                Matrix3x2fStack poseStack = guiGraphics.pose();
                poseStack.pushMatrix();
                GuiGraphicsX.SectorX(guiGraphics, centerX, centerY, this.innerRadius + 10, this.outerRadius, -this.halfFanArc, this.halfFanArc, bgc);
                if (this.isValidIndex(sIndex)) {
                    DT_ListBoxData boxData = this.getData(sIndex);
                    this.drawName(guiGraphics, startAngle, boxData.getComponent().getString(), tc, size);
                }
                poseStack.popMatrix();
            }
        }
    }

    public void drawTextName(GuiGraphics guiGraphics, String name, int color) {
        name = this.font.plainSubstrByWidth(name, this.outerRadius - this.getFanTextInnerSpace());
        int n = this.getFanTextInnerSpace();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, name, n, -9 / 2, color, false);
    }

    protected void drawName(GuiGraphics guiGraphics, double rad, String name, int color, float size) {
        ResourceLocation res = ResourceLocation.tryParse((String)name);
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        if (res != null) {
            float r = (float)((double)this.getFanTextInnerSpace() + (double)(this.outerRadius - this.innerRadius) / 2.0);
            float x2 = (float)(Math.cos(rad) * (double)r);
            float y2 = (float)(Math.sin(rad) * (double)r);
            pose.translate(x2, y2);
            pose.scale(size, size);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, res, -8, -8, 0.0f, 0.0f, 0, 16, 16, 16, 16);
        } else {
            pose.scale(size, size);
            this.drawTextName(guiGraphics, name, color);
        }
        pose.popMatrix();
    }

    public static enum FlipMode {
        tire,
        button;

    }
}

