/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.math._Math;
import dev.anye.mc.cores.am.color.ColorSchemes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public abstract class RenderWidgetCore<T extends RenderWidgetCore<T>>
extends AbstractWidget
implements Renderable {
    protected Font font;
    protected int messageWidth;
    protected int singleCharacterWidth;
    protected int textUsualColor;
    protected int textHoverColor;
    protected int textSelectColor;
    protected int backgroundUsualColor;
    protected int backgroundHoverColor;
    protected int backgroundSelectColor;
    protected int layerZ = 1000;
    protected int halfFontLine;
    protected List<ClientTooltipComponent> customToolTip = new ArrayList<ClientTooltipComponent>();

    public RenderWidgetCore(int x, int y, int w, int h, Component pMessage) {
        this(Minecraft.getInstance().font, x, y, w, h, pMessage);
    }

    public RenderWidgetCore(Font font, int x, int y, int w, int h, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setFont(font);
        this.setColorScheme(ColorSchemes.getGlobal());
    }

    public T setColorScheme(_ColorScheme colorScheme) {
        _ColorScheme.Color color = colorScheme.getColor("text");
        this.textHoverColor = color.HoverColor();
        this.textUsualColor = color.UsualColor();
        this.textSelectColor = color.SelectColor();
        color = colorScheme.getColor("background");
        this.backgroundHoverColor = color.HoverColor();
        this.backgroundUsualColor = color.UsualColor();
        this.backgroundSelectColor = color.SelectColor();
        return this.self();
    }

    protected T self() {
        return (T)((Object)this);
    }

    public Font getFont() {
        return this.font;
    }

    public T setFont(Font font) {
        this.font = font;
        this.setMessageWidth();
        this.setSingleCharacterWidth();
        Objects.requireNonNull(font);
        this.halfFontLine = _Math.half((int)9);
        return this.self();
    }

    public int getMessageWidth() {
        return this.messageWidth;
    }

    public T setMessageWidth() {
        this.messageWidth = this.font.width((FormattedText)this.getMessage());
        return this.self();
    }

    public int getSingleCharacterWidth() {
        return this.singleCharacterWidth;
    }

    public T setSingleCharacterWidth() {
        this.singleCharacterWidth = this.getFont().width("a");
        return this.self();
    }

    public int getLayerZ() {
        return this.layerZ;
    }

    public T setLayerZ(int layerZ) {
        this.layerZ = layerZ;
        return this.self();
    }

    public int getBackgroundUsualColor() {
        return this.backgroundUsualColor;
    }

    public T setBackgroundUsualColor(int backgroundUsualColor) {
        this.backgroundUsualColor = backgroundUsualColor;
        return this.self();
    }

    public int getBackgroundHoverColor() {
        return this.backgroundHoverColor;
    }

    public T setBackgroundHoverColor(int backgroundHoverColor) {
        this.backgroundHoverColor = backgroundHoverColor;
        return this.self();
    }

    public int getTextUsualColor() {
        return this.textUsualColor;
    }

    public void setTextUsualColor(int textUsualColor) {
        this.textUsualColor = textUsualColor;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    protected void drawString(GuiGraphics guiGraphics, Font font, int x, int y, int color, boolean shadow, Component component) {
        guiGraphics.drawString(font, component, x, y, color, shadow);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, boolean shadow, Component component) {
        this.drawString(guiGraphics, this.font, x, y, color, shadow, component);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, Component component) {
        this.drawString(guiGraphics, this.font, x, y, color, false, component);
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, int color, String s) {
        this.drawString(guiGraphics, this.font, x, y, color, false, (Component)Component.literal((String)s));
    }

    protected void drawString(GuiGraphics guiGraphics, int x, int y, Component component) {
        this.drawString(guiGraphics, this.font, x, y, this.backgroundUsualColor, false, component);
    }

    public void setCustomToolTip(List<ClientTooltipComponent> customToolTip) {
        this.customToolTip = customToolTip;
    }

    public List<ClientTooltipComponent> getCustomTooltip() {
        return this.customToolTip;
    }

    protected abstract void renderWidget(@NotNull GuiGraphics var1, int var2, int var3, float var4);

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public static interface OnPress {
        public void onPress();
    }
}

