/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.image;

import dev.anye.mc.cores.screen.widget.DT_ImageInfo;
import dev.anye.mc.cores.screen.widget.DT_XYWH;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ImageButton
extends AbstractWidget
implements Renderable {
    private final Font font;
    private final DT_ImageInfo imageInfo;
    private MouseType mouseType;
    private final OnPress onPress;

    public ImageButton(DT_ImageInfo imageInfo, DT_XYWH xywh, Component pMessage, OnPress onPress) {
        this(imageInfo, xywh.x(), xywh.y(), xywh.width(), xywh.height(), pMessage, onPress);
    }

    public ImageButton(DT_ImageInfo imageInfo, int pX, int pY, int pWidth, int pHeight, Component pMessage, OnPress onPress) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.font = Minecraft.getInstance().font;
        this.mouseType = MouseType.Normal;
        this.imageInfo = imageInfo;
        this.onPress = onPress;
    }

    public boolean mouseClicked(MouseButtonEvent p_447133_, boolean p_434606_) {
        return this.mouseClicked(p_447133_.x(), p_447133_.y(), p_447133_.button()) || super.mouseClicked(p_447133_, p_434606_);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isMouseOver(pMouseX, pMouseY)) {
            this.mouseType = MouseType.Pressed;
            this.onPress.onPress();
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent p_446092_) {
        return this.mouseReleased(p_446092_.x(), p_446092_.y(), p_446092_.button()) || super.mouseReleased(p_446092_);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.mouseType = MouseType.Normal;
        return true;
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        if (!this.isMouseOver(pMouseX, pMouseY)) {
            this.mouseType = MouseType.Normal;
        } else if (this.mouseType == MouseType.Normal) {
            this.mouseType = MouseType.Hover;
        }
        super.mouseMoved(pMouseX, pMouseY);
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int u = this.imageInfo.u;
        int v = this.imageInfo.v;
        if (this.isMouseOver(pMouseX, pMouseY)) {
            u = this.imageInfo.u + this.imageInfo.elementWidth;
            switch (this.mouseType.ordinal()) {
                case 2: {
                    u = this.imageInfo.u + this.imageInfo.elementWidth * 2;
                    break;
                }
                case 4: {
                    u = this.imageInfo.u + this.imageInfo.elementWidth * 3;
                }
            }
        }
        pGuiGraphics.blit(RenderPipelines.GUI, this.imageInfo.image, this.getX(), this.getY(), (float)this.width, (float)this.height, u, v, this.imageInfo.elementWidth, this.imageInfo.elementHeight, this.imageInfo.imageWidth, this.imageInfo.imageHeight);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
    }

    public static interface OnPress {
        public void onPress();
    }

    public static enum MouseType {
        Normal(CoreType.Normal),
        Hover(CoreType.Hover),
        Pressed(CoreType.Hover),
        Released(CoreType.Hover),
        Dragged(CoreType.Hover),
        Scrolled(CoreType.Hover);

        private final CoreType coreType;

        private MouseType(CoreType coreType) {
            this.coreType = coreType;
        }

        public CoreType getCoreType() {
            return this.coreType;
        }

        public static enum CoreType {
            Normal,
            Hover;

        }
    }
}

