/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.mc.cores.screen.widget.simple.SimpleWidgetCore;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;

public class SimpleEditBox
extends SimpleWidgetCore<SimpleEditBox> {
    private String value = "";
    private int maxLength = 32;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (p_94147_, p_94148_) -> FormattedCharSequence.forward((String)p_94147_, (Style)Style.EMPTY);
    @Nullable
    private Component hint;
    private long focusedTime = Util.getMillis();

    public SimpleEditBox(int pWidth, int pHeight, Component pMessage) {
        this(0, 0, pWidth, pHeight, pMessage);
    }

    public SimpleEditBox(int pX, int pY, int pWidth, int pHeight, Component pMessage) {
        this(pX, pY, pWidth, pHeight, null, pMessage);
    }

    public SimpleEditBox(int pX, int pY, int pWidth, int pHeight, @Nullable SimpleEditBox pEditBox, Component pMessage) {
        super(pX, pY, pWidth, pHeight, pMessage);
        if (pEditBox != null) {
            this.setValue(pEditBox.getValue());
        }
    }

    public void setResponder(Consumer<String> pResponder) {
        this.responder = pResponder;
    }

    public void setFormatter(BiFunction<String, Integer, FormattedCharSequence> pTextFormatter) {
        this.formatter = pTextFormatter;
    }

    protected MutableComponent createNarrationMessage() {
        Component component = this.getMessage();
        return Component.translatable((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void setValue(String pText) {
        if (this.filter.test(pText)) {
            this.value = pText.length() > this.maxLength ? pText.substring(0, this.maxLength) : pText;
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(pText);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> pValidator) {
        this.filter = pValidator;
    }

    public void insertText(String pTextToWrite) {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k > 0) {
            String s1;
            String s = StringUtil.filterText((String)pTextToWrite);
            int l = s.length();
            if (k < l) {
                if (Character.isHighSurrogate(s.charAt(k - 1))) {
                    --k;
                }
                s = s.substring(0, k);
                l = k;
            }
            if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
                this.value = s1;
                this.setCursorPosition(i + l);
                this.setHighlightPos(this.cursorPos);
                this.onValueChange(this.value);
            }
        }
    }

    private void onValueChange(String pNewText) {
        if (this.responder != null) {
            this.responder.accept(pNewText);
        }
    }

    private void deleteText(int count, boolean p_446878_) {
        if (p_446878_) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteCharsToPos(this.getWordPosition(pNum));
            }
        }
    }

    public void deleteChars(int pNum) {
        this.deleteCharsToPos(this.getCursorPos(pNum));
    }

    public void deleteCharsToPos(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int j;
                int i = Math.min(pNum, this.cursorPos);
                if (i != (j = Math.max(pNum, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(i, j).toString())) {
                    this.value = s;
                    this.moveCursorTo(i, false);
                }
            }
        }
    }

    public int getWordPosition(int pNumWords) {
        return this.getWordPosition(pNumWords, this.getCursorPosition());
    }

    private int getWordPosition(int pNumWords, int pPos) {
        return this.getWordPosition(pNumWords, pPos, true);
    }

    private int getWordPosition(int pNumWords, int pPos, boolean pSkipConsecutiveSpaces) {
        int i = pPos;
        boolean flag = pNumWords < 0;
        int j = Math.abs(pNumWords);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (pSkipConsecutiveSpaces && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (pSkipConsecutiveSpaces && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pDelta, boolean pSelect) {
        this.moveCursorTo(this.getCursorPos(pDelta), pSelect);
    }

    private int getCursorPos(int pDelta) {
        return Util.offsetByCodepoints((String)this.value, (int)this.cursorPos, (int)pDelta);
    }

    public void moveCursorTo(int pDelta, boolean pSelect) {
        this.setCursorPosition(pDelta);
        if (!pSelect) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int pPos) {
        this.cursorPos = Mth.clamp((int)pPos, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean pSelect) {
        this.moveCursorTo(0, pSelect);
    }

    public void moveCursorToEnd(boolean pSelect) {
        this.moveCursorTo(this.value.length(), pSelect);
    }

    public boolean keyPressed(KeyEvent p_445707_) {
        return this.keyPressed(p_445707_.key(), p_445707_.scancode(), p_445707_.modifiers(), p_445707_) || super.keyPressed(p_445707_);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers, KeyEvent keyEvent) {
        if (this.isActive() && this.isFocused()) {
            switch (pKeyCode) {
                case 259: {
                    if (this.isEditable) {
                        this.deleteText(-1, keyEvent.hasControlDown());
                    }
                    return true;
                }
                default: {
                    if (keyEvent.isSelectAll()) {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        return true;
                    }
                    if (keyEvent.isCopy()) {
                        Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
                        return true;
                    }
                    if (keyEvent.isPaste()) {
                        if (this.isEditable()) {
                            this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
                        }
                        return true;
                    }
                    if (keyEvent.isCut()) {
                        Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlighted());
                        if (this.isEditable()) {
                            this.insertText("");
                        }
                        return true;
                    }
                    return false;
                }
                case 261: {
                    if (this.isEditable) {
                        this.deleteText(1, keyEvent.hasControlDown());
                    }
                    return true;
                }
                case 262: {
                    if (keyEvent.hasControlDown()) {
                        this.moveCursorTo(this.getWordPosition(1), keyEvent.hasShiftDown());
                    } else {
                        this.moveCursor(1, keyEvent.hasShiftDown());
                    }
                    return true;
                }
                case 263: {
                    if (keyEvent.hasControlDown()) {
                        this.moveCursorTo(this.getWordPosition(-1), keyEvent.hasShiftDown());
                    } else {
                        this.moveCursor(-1, keyEvent.hasShiftDown());
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart(keyEvent.hasShiftDown());
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd(keyEvent.hasShiftDown());
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isActive() && this.isFocused() && this.isEditable();
    }

    public boolean charTyped(CharacterEvent p_445625_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (p_445625_.isAllowedChatCharacter()) {
            if (this.isEditable) {
                this.insertText(p_445625_.codepointAsString());
            }
            return true;
        }
        return false;
    }

    public void onClick(MouseButtonEvent p_446284_, boolean p_434599_) {
        int i = Mth.floor((double)p_446284_.x()) - this.getX();
        String s = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.plainSubstrByWidth(s, i -= this.getRadius() * 2).length() + this.displayPos, p_446284_.hasShiftDown());
    }

    public void playDownSound(SoundManager pHandler) {
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textColor = this.isEditable ? this.getTextUsualColor() : this.getTextHoverColor();
        int pos = this.cursorPos - this.displayPos;
        String showText = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean flag = pos >= 0 && pos <= showText.length();
        boolean showFocus = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && flag;
        int startX = this.getContentX() + 2;
        int n = this.getContentY() + this.getContentH() / 2;
        Objects.requireNonNull(this.font);
        int startY = n - 9 / 2;
        int l = startX;
        int i1 = Mth.clamp((int)(this.highlightPos - this.displayPos), (int)0, (int)showText.length());
        if (!showText.isEmpty()) {
            String string = flag ? showText.substring(0, pos) : showText;
        }
        boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int j1 = l;
        if (!flag) {
            j1 = pos > 0 ? startX + this.width : startX;
        } else if (flag2) {
            j1 = l - 1;
            --l;
        }
        if (!showText.isEmpty() && flag && pos < showText.length()) {
            guiGraphics.drawString(this.font, this.formatter.apply(showText.substring(pos), this.cursorPos), l, startY, textColor, false);
        }
        if (this.hint != null && showText.isEmpty() && !this.isFocused()) {
            guiGraphics.drawString(this.font, this.hint, l, startY, textColor, false);
        }
        if (!flag2 && this.suggestion != null) {
            guiGraphics.drawString(this.font, this.suggestion, j1 - 1, startY, -8355712, false);
        }
        if (showFocus) {
            guiGraphics.fill(RenderPipelines.GUI, j1, startY - 1, j1 + 1, startY + 1 + 9, -3092272);
        }
        if (i1 != pos) {
            int k1 = startX + this.font.width(showText.substring(0, i1));
            this.renderHighlight(guiGraphics, j1, startY - 1, k1 - 1, startY + 1 + 9);
        }
    }

    private void renderHighlight(GuiGraphics pGuiGraphics, int pMinX, int pMinY, int pMaxX, int pMaxY) {
        if (pMinX < pMaxX) {
            int i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            int j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        if (pMaxX > this.getX() + this.width) {
            pMaxX = this.getX() + this.width;
        }
        if (pMinX > this.getX() + this.width) {
            pMinX = this.getX() + this.width;
        }
        pGuiGraphics.fill(RenderPipelines.GUI_TEXT_HIGHLIGHT, pMinX, pMinY, pMaxX, pMaxY, this.backgroundSelectColor);
    }

    public void setMaxLength(int pLength) {
        this.maxLength = pLength;
        if (this.value.length() > pLength) {
            this.value = this.value.substring(0, pLength);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setFocused(boolean pFocused) {
        if (this.canLoseFocus || pFocused) {
            super.setFocused(pFocused);
            if (pFocused) {
                this.focusedTime = Util.getMillis();
            }
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean pEnabled) {
        this.isEditable = pEnabled;
    }

    public int getInnerWidth() {
        return this.getContentW() - 4;
    }

    public void setHighlightPos(int pPosition) {
        this.highlightPos = Mth.clamp((int)pPosition, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int pPosition) {
        if (this.font != null) {
            this.displayPos = Math.min(this.displayPos, this.value.length());
            int i = this.getInnerWidth();
            String s = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), i);
            int j = s.length() + this.displayPos;
            if (pPosition == this.displayPos) {
                this.displayPos -= this.font.plainSubstrByWidth(this.value, i, true).length();
            }
            if (pPosition > j) {
                this.displayPos += pPosition - j;
            } else if (pPosition <= this.displayPos) {
                this.displayPos -= this.displayPos - pPosition;
            }
            this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)this.value.length());
        }
    }

    public void setCanLoseFocus(boolean pCanLoseFocus) {
        this.canLoseFocus = pCanLoseFocus;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean pIsVisible) {
        this.visible = pIsVisible;
    }

    public void setSuggestion(@Nullable String pSuggestion) {
        this.suggestion = pSuggestion;
    }

    public int getScreenX(int pCharNum) {
        return pCharNum > this.value.length() ? this.getContentX() : this.getContentX() + this.font.width(this.value.substring(0, pCharNum));
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public void setHint(Component pHint) {
        this.hint = pHint;
    }
}

