/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.mc.cores.render.GuiGraphicsX;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public abstract class SimpleWidgetCore<T extends SimpleWidgetCore<T>>
extends RenderWidgetCore<T> {
    protected int radius;
    protected int borderUsualColor;
    protected int borderHoverColor;
    protected int borderSelectColor;
    protected int contentX;
    protected int contentY;
    protected int contentW;
    protected int contentH;
    protected int contentEndX;
    protected int contentEndY;

    protected SimpleWidgetCore(int x, int y, int w, int h, Component pMessage) {
        this(x, y, w, h, 2, pMessage);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int r, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setRadius(r);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int radius, int borderUsualColor, int borderHoverColor, int textUsualColor, int textHoverColor, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setTextUsualColor(textUsualColor);
        this.setTextHoverColor(textHoverColor);
        this.setBorderUsualColor(borderUsualColor);
        this.setBorderHoverColor(borderHoverColor);
        this.setRadius(radius);
    }

    protected SimpleWidgetCore(int x, int y, int w, int h, int radius, int borderUsualColor, int borderHoverColor, int textUsualColor, int textHoverColor, int backgroundUsualColor, int backgroundHoverColor, Component pMessage) {
        super(x, y, w, h, pMessage);
        this.setTextUsualColor(textUsualColor);
        this.setTextHoverColor(textHoverColor);
        this.setBorderUsualColor(borderUsualColor);
        this.setBorderHoverColor(borderHoverColor);
        this.setBackgroundUsualColor(backgroundUsualColor);
        this.setBackgroundHoverColor(backgroundHoverColor);
        this.setRadius(radius);
    }

    @Override
    public T setColorScheme(_ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        this.setBorderUsualColor(colorScheme.getColor("border").UsualColor());
        this.setBorderHoverColor(colorScheme.getColor("border").HoverColor());
        this.setBorderSelectColor(colorScheme.getColor("border").SelectColor());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public void setWidth(int pWidth) {
        super.setWidth(pWidth);
        this.setRadius(this.getRadius());
    }

    public void setHeight(int pHeight) {
        super.setHeight(pHeight);
        this.setRadius(this.getRadius());
    }

    public T setBorderSelectColor(int borderSelectColor) {
        this.borderSelectColor = borderSelectColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public T setBorderUsualColor(int borderUsualColor) {
        this.borderUsualColor = borderUsualColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getBorderUsualColor() {
        return this.borderUsualColor;
    }

    public T setBorderHoverColor(int borderHoverColor) {
        this.borderHoverColor = borderHoverColor;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getBorderHoverColor() {
        return this.borderHoverColor;
    }

    public T setRadius(int radius) {
        this.radius = radius;
        this.setContentX(this.getX() + radius);
        this.setContentY(this.getY() + radius);
        this.setContentH(this.getHeight() - 2 * radius);
        this.setContentW(this.getWidth() - 2 * radius);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getRadius() {
        return this.radius;
    }

    public T setContentH(int contentH) {
        this.contentH = contentH;
        this.setContentEndY(this.getContentY() + this.contentH);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentH() {
        return this.contentH;
    }

    public T setContentW(int contentW) {
        this.contentW = contentW;
        this.setContentEndX(this.getContentX() + this.contentW);
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentW() {
        return this.contentW;
    }

    public T setContentX(int contentX) {
        this.contentX = contentX;
        this.setContentEndX(this.contentX + this.getContentW());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentX() {
        return this.contentX;
    }

    public T setContentY(int contentY) {
        this.contentY = contentY;
        this.setContentEndY(this.contentY + this.getContentH());
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentY() {
        return this.contentY;
    }

    public T setContentEndX(int contentEndX) {
        this.contentEndX = contentEndX;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentEndX() {
        return this.contentEndX;
    }

    public T setContentEndY(int contentEndY) {
        this.contentEndY = contentEndY;
        return (T)((Object)((SimpleWidgetCore)((Object)this.self())));
    }

    public int getContentEndY() {
        return this.contentEndY;
    }

    protected void renderShape(GuiGraphics poseStack, int borderColor, int fillColor) {
        this.renderShape(poseStack, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getRadius(), borderColor, fillColor);
    }

    protected void renderShape(GuiGraphics poseStack, int x, int y, int width, int height, int radius, int borderColor, int fillColor) {
        GuiGraphicsX.RoundedRect(poseStack, x, y, width, height, radius, borderColor, fillColor);
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            int fillColor;
            int borderColor;
            if (this.isMouseOver(pMouseX, pMouseY)) {
                borderColor = this.getBorderHoverColor();
                fillColor = this.getBackgroundHoverColor();
            } else {
                borderColor = this.getBorderUsualColor();
                fillColor = this.getBackgroundUsualColor();
            }
            Matrix3x2fStack poseStack = guiGraphics.pose();
            poseStack.pushMatrix();
            poseStack.translate(0.0f, 0.0f);
            this.renderShape(guiGraphics, borderColor, fillColor);
            this.renderContent(guiGraphics, pMouseX, pMouseY, pPartialTick);
            poseStack.popMatrix();
        }
    }

    protected abstract void renderContent(GuiGraphics var1, int var2, int var3, float var4);
}

