/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.square;

import dev.anye.mc.cores.render.GuiGraphicsX;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import dev.anye.mc.cores.screen.widget.square.SquareWidgetCore;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class SquareButton
extends SquareWidgetCore<SquareButton> {
    private final RenderWidgetCore.OnPress onPress;
    protected int textUsualColor;
    protected int textSelectColor;
    private int dx;
    private int dy;

    public SquareButton(int x, int y, int w, int h, Component pMessage, RenderWidgetCore.OnPress onPress) {
        super(x, y, w, h, pMessage);
        this.dx = this.getX() + this.width / 2;
        int n = this.getY() + this.height / 2;
        Objects.requireNonNull(this.font);
        this.dy = n - 9 / 2;
        this.onPress = onPress;
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    public void setDy(int dy) {
        this.dy = dy;
    }

    public void setTextSelectColor(int textSelectColor) {
        this.textSelectColor = textSelectColor;
    }

    @Override
    public void setTextUsualColor(int textUsualColor) {
        this.textUsualColor = textUsualColor;
    }

    public void onClick(MouseButtonEvent p_446284_, boolean p_434599_) {
        this.onPress.onPress();
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.drawSquare(guiGraphics, this.backgroundHoverColor);
            guiGraphics.drawCenteredString(this.font, this.getMessage(), this.dx, this.dy, this.textSelectColor);
            GuiGraphicsX.renderTooltip(guiGraphics, this.font, List.of(ClientTooltipComponent.create((FormattedCharSequence)this.getMessage().getVisualOrderText())), mouseX, mouseY);
        } else {
            this.drawSquare(guiGraphics, this.backgroundUsualColor);
            guiGraphics.drawCenteredString(this.font, this.getMessage(), this.dx, this.dy, this.textUsualColor);
        }
    }
}

