/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.helper.entity;

import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityHelper {
    public static Level getLevelCanNull(Entity entity) {
        return entity.level();
    }

    @NotNull
    public static Level getLevel(Entity entity) {
        return entity.level();
    }

    public static long getLevelTime(Entity entity) {
        return EntityHelper.getLevel(entity).getGameTime();
    }

    public static ServerLevel getServerLevel(LivingEntity pLivingEntity) {
        return (ServerLevel)pLivingEntity.level();
    }

    public static BlockEntity getBlockEntity(Level pLevel, BlockPos pPos) {
        return pLevel.getBlockEntity(pPos);
    }

    public static BlockEntity getBlockEntity(LivingEntity pLivingEntity, BlockPos pPos) {
        return EntityHelper.getLevel((Entity)pLivingEntity).getBlockEntity(pPos);
    }

    public static boolean isPlayer(LivingEntity livingEntity) {
        return livingEntity instanceof Player;
    }

    public static boolean isNpc(LivingEntity livingEntity) {
        return livingEntity instanceof Npc;
    }

    public static boolean isAnimal(LivingEntity livingEntity) {
        return livingEntity instanceof Animal;
    }

    public static boolean isPlayerOrNpcOrAnimal(LivingEntity livingEntity) {
        return EntityHelper.isPlayer(livingEntity) || EntityHelper.isNpc(livingEntity) || EntityHelper.isAnimal(livingEntity);
    }

    public static List<Entity> getRadiusEntities(Entity entity, double radius) {
        return EntityHelper.getLevel(entity).getEntities(null, entity.getBoundingBox().inflate(radius));
    }

    public static List<Entity> getRadiusEntities(Level level, AABB aabb, double radius) {
        return level.getEntities(null, aabb.inflate(radius));
    }

    public static boolean isServerLevel(Entity entity) {
        return !EntityHelper.getLevel(entity).isClientSide();
    }

    public static Set<String> getLivingEntityTag(LivingEntity entity) {
        return entity.getTags();
    }

    public static EntityType<?> getEntityType(String id) {
        return (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id)).get()).get();
    }

    public static List<? extends LivingEntity> getLivingEntities(LivingEntity livingEntity) {
        return EntityHelper.getLivingEntities(livingEntity, 10);
    }

    public static List<? extends LivingEntity> getLivingEntities(LivingEntity livingEntity, int radius) {
        return EntityHelper.getLevel((Entity)livingEntity).getEntities(EntityTypeTest.forClass(livingEntity.getClass()), livingEntity.getBoundingBox().inflate((double)radius), Entity::isAlive);
    }

    @Nullable
    public static Entity getViewEntity(Player player, double maxDistance) {
        HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> true, (double)maxDistance);
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            return entityHitResult.getEntity();
        }
        return null;
    }

    @Nullable
    public static LivingEntity getViewLivingEntity(Player player, double maxDistance) {
        EntityHitResult entityHitResult;
        Entity entity2;
        HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> entity instanceof LivingEntity, (double)maxDistance);
        if (result instanceof EntityHitResult && (entity2 = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            return livingEntity;
        }
        return null;
    }
}

