/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.helper.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.anye.mc.cores.helper.attribute.AttributeHelper;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class ItemHelper {
    public static Item getItem(String id) {
        if (Objects.equals(id, "")) {
            return null;
        }
        return (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)id)).get()).get();
    }

    public static double getMainItemDamage(LivingEntity livingEntity) {
        return ItemHelper.getItemDamage(livingEntity.getMainHandItem());
    }

    public static double getItemDamage(String id) {
        Item item = ItemHelper.getItem(id);
        if (item == null) {
            return 0.0;
        }
        return ItemHelper.getItemDamage(new ItemStack((ItemLike)item));
    }

    public static double getItemDamage(ItemStack itemStack) {
        Collection atk = ItemHelper.getAttributeModifiers(itemStack, EquipmentSlot.MAINHAND).get((Object)Attributes.ATTACK_DAMAGE);
        return AttributeHelper.getAttributeModifierValue(atk);
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(ItemStack itemStack, EquipmentSlot pSlot) {
        ItemAttributeModifiers data2;
        HashMultimap multimap = HashMultimap.create();
        if (itemStack.has(DataComponents.ATTRIBUTE_MODIFIERS) && (data2 = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            data2.modifiers().forEach(arg_0 -> ItemHelper.lambda$getAttributeModifiers$0(pSlot, (Multimap)multimap, arg_0));
        }
        return multimap;
    }

    public static boolean hasEnchant(ItemStack itemStack, Enchantment enchantment) {
        return itemStack.getEnchantments().getLevel(Holder.direct((Object)enchantment)) > 0;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(EquipmentSlot pSlot, Multimap multimap, ItemAttributeModifiers.Entry entry) {
        if (entry.slot().test(pSlot)) {
            multimap.put((Object)entry.attribute(), (Object)entry.modifier());
        }
    }
}

