/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.mixin;

import com.mojang.logging.LogUtils;
import dev.anye.mc.cores.am.data.entity.TheWorld;
import dev.anye.mc.cores.am.register.DataReg;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityTickList;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityTickList.class}, priority=0x7FFFFFFF)
public class EntityTickListMixin {
    @Unique
    private static final Logger Cores$LOGGER = LogUtils.getLogger();
    @Shadow
    private Int2ObjectMap<Entity> active;
    @Shadow
    @Nullable
    private Int2ObjectMap<Entity> iterated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void forEach(Consumer<Entity> pEntity) {
        if (this.iterated != null) {
            Cores$LOGGER.warn("Concurrent iteration of entity tick list");
            throw new UnsupportedOperationException("Only one concurrent iteration supported");
        }
        this.iterated = this.active;
        try {
            for (Entity entity : this.active.values()) {
                TheWorld theWorld = (TheWorld)entity.get((DataComponentType)DataReg.THE_WORLD.get());
                if (theWorld != null && theWorld.time() > 0) {
                    entity.setComponent((DataComponentType)DataReg.THE_WORLD.get(), (Object)new TheWorld(theWorld.time() - 1));
                    continue;
                }
                pEntity.accept(entity);
            }
        }
        finally {
            this.iterated = null;
        }
    }
}

