/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.render;

import dev.anye.core.color._ColorCDT;
import dev.anye.mc.cores.render.RenderCore;
import dev.anye.mc.cores.render.element.BorderRenderState;
import dev.anye.mc.cores.render.element.RectRenderState;
import dev.anye.mc.cores.render.element.SectorRenderState;
import dev.anye.mc.cores.render.element.SectorXRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GuiGraphicsX
extends RenderCore {
    public static void Sector(GuiGraphics guiGraphics, int x, int y, int outerRadius, double startArc, double endArc, int color) {
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new SectorRenderState(guiGraphics.pose(), x, y, outerRadius, startArc, endArc, color, GuiGraphicsX.getBounds(x, y, outerRadius), GuiGraphicsX.getBounds(x, y, outerRadius)));
    }

    public static void SectorX(GuiGraphics guiGraphics, int x, int y, int innerRadius, int outerRadius, double startArc, double endArc, int color) {
        if (innerRadius >= outerRadius) {
            if (innerRadius == 0) {
                GuiGraphicsX.Sector(guiGraphics, x, y, outerRadius, startArc, endArc, color);
            }
            return;
        }
        GuiGraphicsX.SectorX(guiGraphics, x, y, innerRadius, innerRadius, outerRadius, outerRadius, startArc, endArc, color);
    }

    public static void SectorX(GuiGraphics guiGraphics, int x, int y, int innerRadiusX, int innerRadiusY, int outerRadiusX, int outerRadiusY, double startArc, double endArc, int color) {
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new SectorXRenderState(guiGraphics.pose(), x, y, innerRadiusX, innerRadiusY, outerRadiusX, outerRadiusY, startArc, endArc, color, GuiGraphicsX.getBounds(x - outerRadiusX, y - outerRadiusY, outerRadiusX + outerRadiusX, outerRadiusY + outerRadiusY), GuiGraphicsX.getBounds(x - outerRadiusX, y - outerRadiusY, outerRadiusX + outerRadiusX, outerRadiusY + outerRadiusY)));
    }

    public static void RoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, int borderColor, int fillColor) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new RectRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)poseStack, x, y, width, height, radius, fillColor, GuiGraphicsX.getBounds(x, y, width, height), GuiGraphicsX.getBounds(x, y, width, height)));
        poseStack.popMatrix();
        poseStack.pushMatrix();
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new BorderRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)poseStack, x, y, width, height, radius, borderColor, GuiGraphicsX.getBounds(x, y, width, height), GuiGraphicsX.getBounds(x, y, width, height)));
        poseStack.popMatrix();
        GuiGraphicsX.Corners(guiGraphics, x, y, width, height, radius, borderColor);
    }

    public static void Corners(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, int color) {
        int minX = x + radius;
        int minY = y + radius;
        int maxX = x + width - radius;
        int maxY = y + height - radius;
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        GuiGraphicsX.SectorX(guiGraphics, minX, minY, 0, radius, Math.PI, 4.71238898038469, color);
        GuiGraphicsX.SectorX(guiGraphics, maxX, minY, 0, radius, 4.71238898038469, Math.PI * 2, color);
        GuiGraphicsX.SectorX(guiGraphics, maxX, maxY, 0, radius, 0.0, 1.5707963267948966, color);
        GuiGraphicsX.SectorX(guiGraphics, minX, maxY, 0, radius, 1.5707963267948966, Math.PI, color);
        poseStack.popMatrix();
    }

    public static void DrawString(GuiGraphics guiGraphics, String str, int x, int y) {
        GuiGraphicsX.DrawString(guiGraphics, Minecraft.getInstance().font, str, x, y, _ColorCDT.black);
    }

    public static void DrawString(GuiGraphics guiGraphics, Font font, String str, int x, int y, int color) {
        guiGraphics.drawString(font, str, x, y, color);
    }

    public static void DrawString(GuiGraphics guiGraphics, Font font, int x, int y, int color, boolean shadow, Component component) {
        guiGraphics.drawString(font, component, x, y, color, shadow);
    }

    public void DrawString(GuiGraphics guiGraphics, int x, int y, int color, boolean shadow, Component component) {
        GuiGraphicsX.DrawString(guiGraphics, Minecraft.getInstance().font, x, y, color, shadow, component);
    }

    public void DrawString(GuiGraphics guiGraphics, int x, int y, int color, Component component) {
        GuiGraphicsX.DrawString(guiGraphics, Minecraft.getInstance().font, x, y, color, false, component);
    }

    public void DrawString(GuiGraphics guiGraphics, int x, int y, Component component) {
        GuiGraphicsX.DrawString(guiGraphics, Minecraft.getInstance().font, x, y, _ColorCDT.black, false, component);
    }

    public static Vector2ic positionTooltip(int screenWidth, int screenHeight, int mouseX, int mouseY, int tooltipWidth, int tooltipHeight) {
        return new Vector2i(mouseX + 16, mouseY);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY) {
        guiGraphics.renderTooltip(font, components, mouseX, mouseY, GuiGraphicsX::positionTooltip, null);
    }

    public static ScreenRectangle getBounds(int x, int y, int w, int h) {
        return new ScreenRectangle(x, y, w, h);
    }

    public static ScreenRectangle getBounds(int x, int y, int r) {
        return new ScreenRectangle(x - r, y - r, r + r, r + r);
    }
}

