/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.debug._DeBug;
import dev.anye.core.math._Math;
import dev.anye.mc.cores.render.GuiGraphicsX;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.simple.SimpleWidgetCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class SimpleDropDownSelectBox
extends SimpleWidgetCore<SimpleDropDownSelectBox> {
    private List<DT_ListBoxData> dataList;
    private int nowSelectIndex = -1;
    private boolean showList = false;
    private int line;
    private int lineHeight;
    private int linePosY;
    private int pages;
    private int nowPage;
    private int usualHeight;
    private int usualContentHeight;
    private int backgroundSelectColor;
    private int textSelectColor;

    public SimpleDropDownSelectBox(int x, int y, int w, int h, Component pMessage, DT_ListBoxData ... data2) {
        this(x, y, w, h, pMessage, Arrays.asList(data2));
    }

    public SimpleDropDownSelectBox(int x, int y, int w, int h, Component pMessage, List<DT_ListBoxData> data2) {
        super(x, y, w, h, pMessage);
        this.dataList = data2;
        this.setUsualHeight(h);
        this.setLine(7);
    }

    public int getNowPage() {
        return this.nowPage;
    }

    public void setNowPage(int nowPage) {
        this.nowPage = nowPage;
    }

    @Override
    public SimpleDropDownSelectBox setColorScheme(_ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        this.setBackgroundSelectColor(colorScheme.getSelectColor("element_background"));
        this.setTextSelectColor(colorScheme.getSelectColor("element_text"));
        return (SimpleDropDownSelectBox)((Object)this.self());
    }

    public int getBackgroundSelectColor() {
        return this.backgroundSelectColor;
    }

    public SimpleDropDownSelectBox setBackgroundSelectColor(int backgroundSelectColor) {
        this.backgroundSelectColor = backgroundSelectColor;
        return (SimpleDropDownSelectBox)((Object)this.self());
    }

    public int getTextSelectColor() {
        return this.textSelectColor;
    }

    public SimpleDropDownSelectBox setTextSelectColor(int textSelectColor) {
        this.textSelectColor = textSelectColor;
        return (SimpleDropDownSelectBox)((Object)this.self());
    }

    @Override
    public SimpleDropDownSelectBox setRadius(int radius) {
        super.setRadius(radius);
        this.setUsualContentHeight(this.getUsualHeight() - 2 * radius);
        this.setLine(this.line);
        return (SimpleDropDownSelectBox)((Object)this.self());
    }

    public int getUsualContentHeight() {
        return this.usualContentHeight;
    }

    public void setUsualContentHeight(int usualContentHeight) {
        this.usualContentHeight = usualContentHeight;
    }

    public int getUsualHeight() {
        return this.usualHeight;
    }

    public void setUsualHeight(int usualHeight) {
        this.usualHeight = usualHeight;
    }

    public void setDataList(DT_ListBoxData ... data2) {
        this.setDataList(Arrays.asList(data2));
    }

    public void setDataList(List<DT_ListBoxData> dataList) {
        this.setNowPage(1);
        this.nowSelectIndex = -1;
        this.dataList = dataList;
    }

    @NotNull
    public List<DT_ListBoxData> getDataList() {
        if (this.dataList == null) {
            this.dataList = new ArrayList<DT_ListBoxData>();
        }
        return this.dataList;
    }

    public int getPages(int number, int line) {
        if (number == 0) {
            return 1;
        }
        int n = number / line;
        if (number % line != 0) {
            ++n;
        }
        return n;
    }

    public SimpleDropDownSelectBox setLine(int line) {
        this.line = line;
        this.lineHeight = this.getUsualContentHeight() * line;
        int n = this.getUsualContentHeight();
        Objects.requireNonNull(this.font);
        this.linePosY = Math.max(_Math.half((int)(n - 9)) + 1, 0);
        this.pages = this.getPages(this.getDataList().size(), line);
        this.setNowPage(1);
        return (SimpleDropDownSelectBox)((Object)this.self());
    }

    public Component getSelectComponent() {
        DT_ListBoxData dropDownListBoxData = this.getSelectData();
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"--");
    }

    public Component getComponent(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getComponent();
        }
        return Component.literal((String)"--");
    }

    public List<ClientTooltipComponent> getDataTooltip(int index) {
        DT_ListBoxData dropDownListBoxData = this.getData(index);
        if (dropDownListBoxData != null) {
            return dropDownListBoxData.getTooltip();
        }
        return List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)"--").getVisualOrderText()));
    }

    public DT_ListBoxData getSelectData() {
        if (this.nowSelectIndex >= 0 && this.nowSelectIndex < this.dataList.size()) {
            return this.dataList.get(this.nowSelectIndex);
        }
        return null;
    }

    public DT_ListBoxData getData(int index) {
        int i = (this.getNowPage() - 1) * this.line + index;
        if (i >= 0 && i < this.dataList.size()) {
            return this.dataList.get(i);
        }
        return null;
    }

    public Object getSelectValue() {
        if (this.nowSelectIndex > this.dataList.size() || this.nowSelectIndex < 0) {
            _DeBug.ThrowError((String)"Error Select");
            return null;
        }
        return this.dataList.get(this.nowSelectIndex).getValue();
    }

    public boolean setSelect(int index) {
        if (index > this.dataList.size() || index < 0) {
            return false;
        }
        this.nowSelectIndex = index;
        return true;
    }

    public int getNowSelectIndex() {
        return this.nowSelectIndex;
    }

    public String FixStrWidth(String s) {
        return this.font.plainSubstrByWidth(s, this.width);
    }

    public String FixStrWidth(Component s) {
        return this.FixStrWidth(s.getString());
    }

    public void onClick(MouseButtonEvent pEvent, boolean pIsDoubleClick) {
        this.onClick(pEvent.x(), pEvent.y());
    }

    public void onClick(double pMouseX, double pMouseY) {
        this.showList = !this.showList;
        int np = this.getNowPage();
        if (this.showList) {
            this.setHeight(this.getUsualHeight() + this.lineHeight);
        } else {
            this.setHeight(this.getUsualHeight());
        }
        this.updateIndex(pMouseY, np);
    }

    public void updateIndex(double mouseY, int page) {
        int i = (int)((mouseY - (double)this.getContentY()) / (double)this.getContentH());
        if (i > 0) {
            this.nowSelectIndex = i - 1;
            this.nowSelectIndex += (page - 1) * this.line;
            DT_ListBoxData dropDownListBoxData = this.getSelectData();
            if (dropDownListBoxData != null) {
                dropDownListBoxData.OnPress(this.getSelectValue());
            }
        }
    }

    public boolean isInWidget(double pMouseX, double pMouseY) {
        return pMouseX > (double)this.getContentX() && pMouseX < (double)(this.getContentX() + this.getContentW()) && pMouseY > (double)this.getContentY() && pMouseY < (double)(this.getContentY() + this.getContentH());
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (this.showList && this.isInWidget(pMouseX, pMouseY)) {
            if (sy < 0.0 && this.getNowPage() < this.pages) {
                this.setNowPage(this.getNowPage() + 1);
            } else if (sy > 0.0 && this.getNowPage() > 1) {
                this.setNowPage(this.getNowPage() - 1);
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.showList) {
            Matrix3x2fStack poseStack = pGuiGraphics.pose();
            poseStack.pushMatrix();
            poseStack.translate(0.0f, 0.0f);
            super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            poseStack.popMatrix();
            return;
        }
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        Component c = this.getMessage();
        if (this.nowSelectIndex > -1 || c.equals((Object)Component.empty())) {
            c = this.getSelectComponent();
        }
        int sx = this.getContentX() + 1;
        int sy = this.getContentY();
        guiGraphics.drawString(this.getFont(), (Component)Component.literal((String)this.FixStrWidth(c)), sx, sy + this.linePosY, this.getTextHoverColor(), false);
        if (this.showList) {
            for (int i = 0; i < this.line; ++i) {
                boolean mouseOver;
                int lineH = (i + 1) * this.getUsualContentHeight();
                int lineY = this.getContentY() + lineH;
                Component select = this.getComponent(i);
                int tc = this.getTextUsualColor();
                boolean bl = mouseOver = mouseX > this.getContentX() && mouseX < this.getContentEndX() && mouseY > lineY && mouseY < lineY + this.getUsualContentHeight();
                if (mouseOver) {
                    tc = this.getTextSelectColor();
                    guiGraphics.fill(this.getContentX(), lineY, this.getContentEndX(), lineY + this.getUsualContentHeight(), this.getBackgroundSelectColor());
                }
                guiGraphics.drawString(this.getFont(), (Component)Component.literal((String)this.FixStrWidth(select)), sx, sy + lineH + this.linePosY, tc, false);
                if (!mouseOver) continue;
                GuiGraphicsX.renderTooltip(guiGraphics, this.font, this.getDataTooltip(i), mouseX, mouseY);
            }
        }
        poseStack.popMatrix();
    }
}

