/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.cores.screen.widget.simple;

import dev.anye.core.color.scheme._ColorScheme;
import dev.anye.core.debug._DeBug;
import dev.anye.core.math._Math;
import dev.anye.mc.cores.render.GuiGraphicsX;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.simple.SimpleWidgetCore;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class SimpleListBox
extends SimpleWidgetCore<SimpleListBox> {
    protected List<DT_ListBoxData> data;
    protected int dataSize;
    protected int line;
    protected int row;
    protected int index;
    protected int startIndex;
    protected int elementalWidth;
    protected int elementalHeight;
    protected int widthSpace;
    protected int heightSpace;
    protected int strX = 1;
    protected int strY;
    protected int elementalBorderUsualColor;
    protected int elementalBorderHoverColor;
    protected int elementalTextUsualColor;
    protected int elementalTextHoverColor;
    protected int elementalBackgroundUsualColor;
    protected int elementalBackgroundHoverColor;

    public SimpleListBox(int x, int y, int w, int h, int elementalWidth, int elementalHeight, Component pMessage, List<DT_ListBoxData> data2) {
        super(x, y, w, h, pMessage);
        this.data = data2;
        this.dataSize = this.data.size();
        this.elementalWidth = elementalWidth;
        this.elementalHeight = elementalHeight;
        this.widthSpace = 4;
        this.heightSpace = 4;
        this.index = -1;
        this.startIndex = 0;
        this.setStrY();
        this.resetAutoSpace();
    }

    @Override
    public SimpleListBox setColorScheme(_ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        _ColorScheme.Color color = colorScheme.getColor("element_border");
        this.elementalBorderHoverColor = color.HoverColor();
        this.elementalBorderUsualColor = color.UsualColor();
        color = colorScheme.getColor("element_text");
        this.elementalTextHoverColor = color.HoverColor();
        this.elementalTextUsualColor = color.UsualColor();
        color = colorScheme.getColor("element_background");
        this.elementalBackgroundHoverColor = color.HoverColor();
        this.elementalBackgroundUsualColor = color.UsualColor();
        return (SimpleListBox)((Object)this.self());
    }

    public SimpleListBox setElementalTextHoverColor(int elementalTextHoverColor) {
        this.elementalTextHoverColor = elementalTextHoverColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalTextHoverColor() {
        return this.elementalTextHoverColor;
    }

    public SimpleListBox setElementalTextUsualColor(int elementalTextUsualColor) {
        this.elementalTextUsualColor = elementalTextUsualColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalTextUsualColor() {
        return this.elementalTextUsualColor;
    }

    public SimpleListBox setElementalBorderHoverColor(int elementalBorderHoverColor) {
        this.elementalBorderHoverColor = elementalBorderHoverColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalBorderHoverColor() {
        return this.elementalBorderHoverColor;
    }

    public SimpleListBox setElementalBorderUsualColor(int elementalBorderUsualColor) {
        this.elementalBorderUsualColor = elementalBorderUsualColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalBorderUsualColor() {
        return this.elementalBorderUsualColor;
    }

    public SimpleListBox setElementalBackgroundHoverColor(int elementalBackgroundHoverColor) {
        this.elementalBackgroundHoverColor = elementalBackgroundHoverColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalBackgroundHoverColor() {
        return this.elementalBackgroundHoverColor;
    }

    public SimpleListBox setElementalBackgroundUsualColor(int elementalBackgroundUsualColor) {
        this.elementalBackgroundUsualColor = elementalBackgroundUsualColor;
        return (SimpleListBox)((Object)this.self());
    }

    public int getElementalBackgroundUsualColor() {
        return this.elementalBackgroundUsualColor;
    }

    public SimpleListBox setData(List<DT_ListBoxData> data2) {
        this.data = data2;
        this.dataSize = this.data.size();
        this.index = -1;
        this.startIndex = 0;
        return (SimpleListBox)((Object)this.self());
    }

    @Override
    public SimpleListBox setFont(Font font) {
        super.setFont(font);
        this.setStrY();
        return (SimpleListBox)((Object)this.self());
    }

    public void resetAutoSpace() {
        int i = this.getElementalWidth() + this.getWidthSpace() * 2;
        this.row = this.getContentW() / i;
        int space = (this.getContentW() - this.row * i) / this.row;
        this.widthSpace += _Math.half1((int)space);
        i = this.getElementalHeight() + this.getHeightSpace() * 2;
        this.line = this.getContentH() / i;
        space = (this.getContentH() - this.line * i) / this.line;
        this.heightSpace += _Math.half1((int)space);
    }

    public void setStrY() {
        int n = this.getElementalContentHeight();
        Objects.requireNonNull(this.font);
        this.strY = _Math.half1((int)(n / 9)) + 1;
    }

    public int getStrY() {
        return this.strY;
    }

    public void setElementalHeight(int elementalHeight) {
        this.elementalHeight = elementalHeight;
        this.resetAutoSpace();
    }

    public int getElementalHeight() {
        return this.elementalHeight;
    }

    public void setElementalWidth(int elementalWidth) {
        this.elementalWidth = elementalWidth;
        this.resetAutoSpace();
    }

    public int getElementalWidth() {
        return this.elementalWidth;
    }

    public int getWidthSpace() {
        return this.widthSpace;
    }

    public void setWidthSpace(int widthSpace) {
        this.widthSpace = widthSpace;
        this.resetAutoSpace();
    }

    public int getHeightSpace() {
        return this.heightSpace;
    }

    public void setHeightSpace(int heightSpace) {
        this.heightSpace = heightSpace;
        this.resetAutoSpace();
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int idex = -1;
        for (int i = 0; i < this.line; ++i) {
            int elemY = this.getContentY() + this.getHeightSpace() + i * (this.getElementalHeight() + this.getHeightSpace() + this.getHeightSpace());
            for (int r = 0; r < this.row && this.startIndex < this.dataSize; ++r) {
                boolean mouseOver;
                int elemIndex = this.startIndex + i * this.row + r;
                if (elemIndex >= this.dataSize) continue;
                int elemX = this.getContentX() + this.getWidthSpace() + r * (this.getElementalWidth() + this.getWidthSpace() + this.getWidthSpace());
                int borderColor = this.getElementalBorderUsualColor();
                int backgroundColor = this.getElementalBackgroundUsualColor();
                int txtColor = this.getElementalTextUsualColor();
                boolean bl = mouseOver = mouseX > elemX && mouseX < elemX + this.elementalWidth && mouseY > elemY && mouseY < elemY + this.elementalHeight;
                if (mouseOver) {
                    borderColor = this.getElementalBorderHoverColor();
                    backgroundColor = this.getElementalBackgroundHoverColor();
                    txtColor = this.getElementalTextHoverColor();
                    idex = elemIndex;
                }
                Matrix3x2fStack poseStack = guiGraphics.pose();
                poseStack.pushMatrix();
                this.renderShape(guiGraphics, elemX, elemY, this.elementalWidth, this.elementalHeight, this.getRadius(), borderColor, backgroundColor);
                poseStack.popMatrix();
                this.drawString(guiGraphics, elemX + this.getRadius() + this.strX, elemY + this.getRadius() + this.getStrY(), txtColor, this.FixStrWidth(this.getDataComponent(elemIndex)));
                if (!mouseOver) continue;
                GuiGraphicsX.renderTooltip(guiGraphics, this.font, this.getData(elemIndex).getTooltip(), mouseX, mouseY);
            }
        }
        this.index = idex;
    }

    public DT_ListBoxData getData(int index) {
        if (index < this.data.size()) {
            return this.data.get(index);
        }
        _DeBug.ThrowError((String)"error index");
        return null;
    }

    public Component getDataComponent(int index) {
        DT_ListBoxData d = this.getData(index);
        if (d != null) {
            return d.getComponent();
        }
        _DeBug.ThrowError((String)"error data");
        return Component.literal((String)"Error :: Null");
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double sx, double sy) {
        if (sy < 0.0 && this.startIndex < this.dataSize - this.row) {
            this.startIndex += this.row;
        } else if (this.startIndex >= this.row) {
            this.startIndex -= this.row;
        }
        this.index = -1;
        return super.mouseScrolled(pMouseX, pMouseY, sx, sy);
    }

    public void onClick(MouseButtonEvent pEvent, boolean pIsDoubleClick) {
        this.onClick(pEvent.x(), pEvent.y());
    }

    public void onClick(double pMouseX, double pMouseY) {
        DT_ListBoxData d;
        if (this.isMouseOver(pMouseX, pMouseY) && this.index >= 0 && (d = this.getData(this.index)) != null) {
            d.OnPress(d.getValue());
        }
    }

    public String FixStrWidth(String s) {
        return this.font.plainSubstrByWidth(s, this.getElementalContentWidth());
    }

    public String FixStrWidth(Component s) {
        return this.FixStrWidth(s.getString());
    }

    public int getElementalContentWidth() {
        return this.getElementalWidth() - 2 * this.getRadius();
    }

    public int getElementalContentHeight() {
        return this.getElementalHeight() - 2 * this.getRadius();
    }
}

