/*
 * Decompiled with CFR 0.152.
 */
package itemtransformhelper;

import com.google.common.collect.ImmutableMap;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import itemtransformhelper.HUDTextRenderer;
import itemtransformhelper.UpdateLink;
import itemtransformhelper.neoforge.MenuItemCameraTransformsImpl;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

public class MenuItemCameraTransforms {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HUDTextRenderer.HUDInfoUpdateLink linkToHudRenderer = new HUDTextRenderer.HUDInfoUpdateLink();

    public MenuItemCameraTransforms() {
        MenuKeyHandler menuKeyHandler = new MenuKeyHandler(new KeyPressCallback());
        ClientTickEvent.CLIENT_PRE.register(mc -> menuKeyHandler.clientTick());
        MenuItemCameraTransforms.registerListeners(new HUDTextRenderer(this.linkToHudRenderer));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerListeners(HUDTextRenderer hudTextRenderer) {
        MenuItemCameraTransformsImpl.registerListeners(hudTextRenderer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemTransforms newItemTransforms(ItemTransform thirdPersonLeftHand, ItemTransform thirdPersonRightHand, ItemTransform firstPersonLeftHand, ItemTransform firstPersonRightHand, ItemTransform head, ItemTransform gui, ItemTransform ground, ItemTransform fixed, ItemTransform onShelf, ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms) {
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return MenuItemCameraTransformsImpl.newItemTransforms(thirdPersonLeftHand, (ItemTransform)var1_1, (ItemTransform)var2_2, (ItemTransform)var3_3, (ItemTransform)var4_4, (ItemTransform)var5_5, (ItemTransform)var6_6, (ItemTransform)var7_7, (ItemTransform)var8_8, (ImmutableMap<ItemDisplayContext, ItemTransform>)var9_9);
    }

    public ItemTransforms getItemCameraTransforms() {
        return this.linkToHudRenderer.itemCameraTransforms;
    }

    public void changeMenuVisible(boolean visible) {
        this.linkToHudRenderer.menuVisible = visible;
    }

    private void alterField(boolean increase) {
        ItemTransform transform = this.linkToHudRenderer.getItemTransform();
        if (transform == null) {
            return;
        }
        float SCALE_INCREMENT = 0.01f;
        float ROTATION_INCREMENT = 2.0f;
        float TRANSLATION_INCREMENT = 0.015625f;
        switch (this.linkToHudRenderer.selectedField) {
            case TRANSFORM: {
                this.linkToHudRenderer.selectedTransform = increase ? this.linkToHudRenderer.selectedTransform.getNext() : this.linkToHudRenderer.selectedTransform.getPrevious();
                break;
            }
            case SCALE_X: 
            case SCALE_Y: 
            case SCALE_Z: {
                this.changeSelectedField(f -> Float.valueOf(f.floatValue() + (increase ? 0.01f : -0.01f)));
                break;
            }
            case ROTATE_X: 
            case ROTATE_Y: 
            case ROTATE_Z: {
                this.changeSelectedField(f -> Float.valueOf(Mth.wrapDegrees((float)(f.floatValue() + (increase ? 2.0f : -2.0f) - 180.0f)) + 180.0f));
                break;
            }
            case TRANSLATE_X: 
            case TRANSLATE_Y: 
            case TRANSLATE_Z: {
                this.changeSelectedField(f -> Float.valueOf(f.floatValue() + (increase ? 0.015625f : -0.015625f)));
                break;
            }
            case RESTORE_DEFAULT_ALL: 
            case RESTORE_DEFAULT: {
                ItemTransforms originalTransforms = UpdateLink.INSTANCE.originalTransforms;
                if (originalTransforms == null) break;
                UpdateLink.INSTANCE.originalTransforms = null;
                if (this.linkToHudRenderer.selectedField == HUDTextRenderer.HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT) {
                    this.linkToHudRenderer.itemCameraTransforms = MenuItemCameraTransforms.changeTransforms(this.linkToHudRenderer.itemCameraTransforms, this.linkToHudRenderer.selectedTransform, this.linkToHudRenderer.selectedTransform.getItemTransform(originalTransforms));
                    break;
                }
                this.linkToHudRenderer.itemCameraTransforms = originalTransforms;
                break;
            }
            case PRINT: {
                StringBuilder output = new StringBuilder();
                output.append("\n\"display\": {\n");
                MenuItemCameraTransforms.printTransform(output, "thirdperson_righthand", this.linkToHudRenderer.itemCameraTransforms.thirdPersonRightHand());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "thirdperson_lefthand", this.linkToHudRenderer.itemCameraTransforms.thirdPersonLeftHand());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "firstperson_righthand", this.linkToHudRenderer.itemCameraTransforms.firstPersonRightHand());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "firstperson_lefthand", this.linkToHudRenderer.itemCameraTransforms.firstPersonLeftHand());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "gui", this.linkToHudRenderer.itemCameraTransforms.gui());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "head", this.linkToHudRenderer.itemCameraTransforms.head());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "fixed", this.linkToHudRenderer.itemCameraTransforms.fixed());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "ground", this.linkToHudRenderer.itemCameraTransforms.ground());
                output.append("\n}");
                LOGGER.info((CharSequence)output);
                MutableComponent text = Component.literal((String)"\"display\" JSON section printed to console (LOGGER.info)...");
                Minecraft.getInstance().gui.getChat().addMessage((Component)text);
            }
        }
    }

    private void changeSelectedField(UnaryOperator<Float> modifier) {
        this.linkToHudRenderer.itemCameraTransforms = MenuItemCameraTransforms.changeTransforms(this.linkToHudRenderer.itemCameraTransforms, this.linkToHudRenderer.selectedTransform, MenuItemCameraTransforms.changeTransform(this.linkToHudRenderer.getItemTransform(), this.linkToHudRenderer.selectedField, MenuItemCameraTransforms.changeVec(this.linkToHudRenderer.getItemTransformVec(), this.linkToHudRenderer.selectedField, ((Float)modifier.apply(Float.valueOf(this.linkToHudRenderer.getItemTransformVecValue()))).floatValue())));
    }

    public static ItemTransforms changeTransforms(ItemTransforms old, HUDTextRenderer.HUDInfoUpdateLink.TransformName selectedTransform, ItemTransform newTransform) {
        return MenuItemCameraTransforms.newItemTransforms(selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.THIRD_LEFT ? newTransform : old.thirdPersonLeftHand(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.THIRD_RIGHT ? newTransform : old.thirdPersonRightHand(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIRST_LEFT ? newTransform : old.firstPersonLeftHand(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIRST_RIGHT ? newTransform : old.firstPersonRightHand(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.HEAD ? newTransform : old.head(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.GUI ? newTransform : old.gui(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.GROUND ? newTransform : old.ground(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIXED ? newTransform : old.fixed(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.ON_SHELF ? newTransform : old.fixedFromBottom(), (ImmutableMap<ItemDisplayContext, ItemTransform>)ImmutableMap.of());
    }

    public static ItemTransform changeTransform(ItemTransform old, HUDTextRenderer.HUDInfoUpdateLink.SelectedField selectedField, Vector3fc newTransform) {
        return new ItemTransform(selectedField.isRotation() ? newTransform : old.rotation(), selectedField.isTranslation() ? newTransform : old.translation(), selectedField.isScale() ? newTransform : old.scale());
    }

    public static Vector3fc changeVec(Vector3fc old, HUDTextRenderer.HUDInfoUpdateLink.SelectedField selectedField, float newValue) {
        return new Vector3f(selectedField.isX() ? newValue : old.x(), selectedField.isY() ? newValue : old.y(), selectedField.isZ() ? newValue : old.z());
    }

    private static void printTransform(StringBuilder output, String transformView, ItemTransform transformation) {
        Locale LOCALE = Locale.US;
        output.append("    \"").append(transformView).append("\": {\n");
        output.append(String.format(LOCALE, "        \"rotation\": [ %.0f, %.0f, %.0f ],\n", Float.valueOf(transformation.rotation().x()), Float.valueOf(transformation.rotation().y()), Float.valueOf(transformation.rotation().z())));
        double TRANSLATE_MULTIPLIER = 16.0;
        output.append(String.format(LOCALE, "        \"translation\": [ %.2f, %.2f, %.2f ],\n", (double)transformation.translation().x() * 16.0, (double)transformation.translation().y() * 16.0, (double)transformation.translation().z() * 16.0));
        output.append(String.format(LOCALE, "        \"scale\": [ %.2f, %.2f, %.2f ]\n", Float.valueOf(transformation.scale().x()), Float.valueOf(transformation.scale().y()), Float.valueOf(transformation.scale().z())));
        output.append("    }");
    }

    public static class MenuKeyHandler {
        private final KeyPressCallback keyPressCallback;
        private long keyDownTimeTicks = 0L;
        private ArrowKeys lastKey = ArrowKeys.NONE;

        public MenuKeyHandler(KeyPressCallback keyPressCallback) {
            this.keyPressCallback = keyPressCallback;
        }

        public void clientTick() {
            int INITIAL_PAUSE_TICKS = 10;
            ArrowKeys keyPressed = ArrowKeys.NONE;
            if (MenuKeyHandler.isKeyDown(263)) {
                keyPressed = ArrowKeys.LEFT;
            }
            if (MenuKeyHandler.isKeyDown(262)) {
                keyPressed = ArrowKeys.RIGHT;
            }
            if (MenuKeyHandler.isKeyDown(264)) {
                keyPressed = ArrowKeys.DOWN;
            }
            if (MenuKeyHandler.isKeyDown(265)) {
                keyPressed = ArrowKeys.UP;
            }
            if (keyPressed == ArrowKeys.NONE) {
                this.lastKey = ArrowKeys.NONE;
                return;
            }
            if (keyPressed != this.lastKey) {
                this.lastKey = keyPressed;
                this.keyDownTimeTicks = 0L;
            } else if (++this.keyDownTimeTicks < 10L) {
                return;
            }
            this.keyPressCallback.keyPressed(keyPressed);
        }

        private static boolean isKeyDown(int key) {
            return GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().handle(), (int)key) == 1;
        }

        public static enum ArrowKeys {
            NONE,
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    public class KeyPressCallback {
        void keyPressed(MenuKeyHandler.ArrowKeys whichKey) {
            if (!MenuItemCameraTransforms.this.linkToHudRenderer.menuVisible) {
                return;
            }
            switch (whichKey.ordinal()) {
                case 2: {
                    MenuItemCameraTransforms.this.linkToHudRenderer.selectedField = MenuItemCameraTransforms.this.linkToHudRenderer.selectedField.getNextField();
                    break;
                }
                case 1: {
                    MenuItemCameraTransforms.this.linkToHudRenderer.selectedField = MenuItemCameraTransforms.this.linkToHudRenderer.selectedField.getPreviousField();
                    break;
                }
                case 3: 
                case 4: {
                    MenuItemCameraTransforms.this.alterField(whichKey == MenuKeyHandler.ArrowKeys.RIGHT);
                    break;
                }
            }
        }
    }
}

