/*
 * Decompiled with CFR 0.152.
 */
package itemtransformhelper;

import com.google.common.collect.ImmutableMap;
import itemtransformhelper.MenuItemCameraTransforms;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HUDTextRenderer {
    private static final HUDInfoUpdateLink.SelectedField NOT_SELECTABLE = null;
    private static final int MED_GRAY_HALF_TRANSPARENT = 1873784752;
    private static final int GREEN_HALF_TRANSPARENT = 0x6F00FF00;
    private static final int LIGHT_GRAY = -2039584;
    private static final int BLACK = -16777216;
    private final HUDInfoUpdateLink hudInfoUpdateLink;

    public HUDTextRenderer(HUDInfoUpdateLink hudInfoUpdateLink) {
        this.hudInfoUpdateLink = hudInfoUpdateLink;
    }

    public void displayHUDText(GuiGraphics guiGraphics) {
        if (this.hudInfoUpdateLink == null || !this.hudInfoUpdateLink.menuVisible) {
            return;
        }
        ArrayList<Object> displayText = new ArrayList<Object>();
        ArrayList<HUDInfoUpdateLink.SelectedField> selectableField = new ArrayList<HUDInfoUpdateLink.SelectedField>();
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("VIEW  ");
        selectableField.add(NOT_SELECTABLE);
        switch (this.hudInfoUpdateLink.selectedTransform.ordinal()) {
            case 0: {
                displayText.add("3rd-L");
                break;
            }
            case 1: {
                displayText.add("3rd-R");
                break;
            }
            case 2: {
                displayText.add("1st-L");
                break;
            }
            case 3: {
                displayText.add("1st-R");
                break;
            }
            case 4: {
                displayText.add("head");
                break;
            }
            case 5: {
                displayText.add("gui");
                break;
            }
            case 6: {
                displayText.add("grnd");
                break;
            }
            case 7: {
                displayText.add("fixed");
                break;
            }
            case 8: {
                displayText.add("shelf");
            }
        }
        ItemTransform transformation = this.hudInfoUpdateLink.getItemTransform();
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSFORM);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("SCALE");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%.2f", Float.valueOf(transformation.scale().x())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_X);
        displayText.add("Y:" + String.format("%.2f", Float.valueOf(transformation.scale().y())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_Y);
        displayText.add("Z:" + String.format("%.2f", Float.valueOf(transformation.scale().z())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_Z);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("ROTATE");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%3.0f", Float.valueOf(transformation.rotation().x())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_X);
        displayText.add("Y:" + String.format("%3.0f", Float.valueOf(transformation.rotation().y())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_Y);
        displayText.add("Z:" + String.format("%3.0f", Float.valueOf(transformation.rotation().z())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_Z);
        double TRANSLATE_MULTIPLIER = 16.0;
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("TRANSL");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%.2f", (double)transformation.translation().x() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_X);
        displayText.add("Y:" + String.format("%.2f", (double)transformation.translation().y() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_Y);
        displayText.add("Z:" + String.format("%.2f", (double)transformation.translation().z() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_Z);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("RESET");
        selectableField.add(HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT);
        displayText.add("RSTALL");
        selectableField.add(HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT_ALL);
        displayText.add("PRINT");
        selectableField.add(HUDInfoUpdateLink.SelectedField.PRINT);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        Font font = Minecraft.getInstance().font;
        int yPos = 2;
        int xPos = 2;
        for (int i = 0; i < displayText.size(); ++i) {
            String msg = (String)displayText.get(i);
            Objects.requireNonNull(font);
            yPos += 9;
            if (msg == null) continue;
            boolean fieldIsSelected = this.hudInfoUpdateLink.selectedField == selectableField.get(i);
            int highlightColour = fieldIsSelected ? 0x6F00FF00 : 1873784752;
            int n = xPos + font.width(msg) + 1;
            Objects.requireNonNull(font);
            guiGraphics.fill(xPos - 1, yPos - 1, n, yPos + 9 - 1, highlightColour);
            int stringColour = fieldIsSelected ? -16777216 : -2039584;
            guiGraphics.drawString(font, msg, xPos, yPos, stringColour, false);
        }
    }

    public static class HUDInfoUpdateLink {
        private static final Vector3f ROTATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f TRANSLATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f SCALE_DEFAULT = new Vector3f(1.0f, 1.0f, 1.0f);
        public ItemTransforms itemCameraTransforms;
        public SelectedField selectedField;
        public TransformName selectedTransform;
        public boolean menuVisible;

        public HUDInfoUpdateLink() {
            ItemTransform trThirdLeft = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trThirdRight = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trFirstLeft = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trFirstRight = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trHead = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trGui = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trGround = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trFixed = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            ItemTransform trOnShelf = new ItemTransform((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            this.itemCameraTransforms = MenuItemCameraTransforms.newItemTransforms(trThirdLeft, trThirdRight, trFirstLeft, trFirstRight, trHead, trGui, trGround, trFixed, trOnShelf, (ImmutableMap<ItemDisplayContext, ItemTransform>)ImmutableMap.of());
            this.selectedField = SelectedField.TRANSFORM;
            this.selectedTransform = TransformName.FIRST_RIGHT;
            this.menuVisible = false;
        }

        public ItemTransform getItemTransform() {
            return this.selectedTransform.getItemTransform(this.itemCameraTransforms);
        }

        public Vector3fc getItemTransformVec() {
            return this.selectedField.getItemTransformVec(this.itemCameraTransforms, this.selectedTransform);
        }

        public float getItemTransformVecValue() {
            return this.selectedField.getItemTransformVecValue(this.itemCameraTransforms, this.selectedTransform);
        }

        public static enum SelectedField {
            TRANSFORM(0),
            SCALE_X(1),
            SCALE_Y(2),
            SCALE_Z(3),
            ROTATE_X(4),
            ROTATE_Y(5),
            ROTATE_Z(6),
            TRANSLATE_X(7),
            TRANSLATE_Y(8),
            TRANSLATE_Z(9),
            RESTORE_DEFAULT(10),
            RESTORE_DEFAULT_ALL(11),
            PRINT(12);

            public static final SelectedField[] VALUES;
            private static final SelectedField FIRST_FIELD;
            private static final SelectedField LAST_FIELD;
            public final int fieldIndex;

            private SelectedField(int index) {
                this.fieldIndex = index;
            }

            public static SelectedField getFieldName(int indexToFind) {
                for (SelectedField checkField : VALUES) {
                    if (checkField.fieldIndex != indexToFind) continue;
                    return checkField;
                }
                return null;
            }

            public SelectedField getNextField() {
                SelectedField nextField = SelectedField.getFieldName(this.fieldIndex + 1);
                if (nextField == null) {
                    nextField = FIRST_FIELD;
                }
                return nextField;
            }

            public SelectedField getPreviousField() {
                SelectedField previousField = SelectedField.getFieldName(this.fieldIndex - 1);
                if (previousField == null) {
                    previousField = LAST_FIELD;
                }
                return previousField;
            }

            public Vector3fc getItemTransformVec(ItemTransforms transforms, TransformName selectedTransform) {
                ItemTransform transform = selectedTransform.getItemTransform(transforms);
                if (this.isScale()) {
                    return transform.scale();
                }
                if (this.isRotation()) {
                    return transform.rotation();
                }
                if (this.isTranslation()) {
                    return transform.translation();
                }
                return null;
            }

            public float getItemTransformVecValue(ItemTransforms transforms, TransformName selectedTransform) {
                Vector3fc vec = this.getItemTransformVec(transforms, selectedTransform);
                if (this.isX()) {
                    return Objects.requireNonNull(vec).x();
                }
                if (this.isY()) {
                    return Objects.requireNonNull(vec).y();
                }
                if (this.isZ()) {
                    return Objects.requireNonNull(vec).z();
                }
                return 0.0f;
            }

            public boolean isScale() {
                return this == SCALE_X || this == SCALE_Y || this == SCALE_Z;
            }

            public boolean isRotation() {
                return this == ROTATE_X || this == ROTATE_Y || this == ROTATE_Z;
            }

            public boolean isTranslation() {
                return this == TRANSLATE_X || this == TRANSLATE_Y || this == TRANSLATE_Z;
            }

            public boolean isX() {
                return this == SCALE_X || this == ROTATE_X || this == TRANSLATE_X;
            }

            public boolean isY() {
                return this == SCALE_Y || this == ROTATE_Y || this == TRANSLATE_Y;
            }

            public boolean isZ() {
                return this == SCALE_Z || this == ROTATE_Z || this == TRANSLATE_Z;
            }

            static {
                VALUES = SelectedField.values();
                FIRST_FIELD = TRANSFORM;
                LAST_FIELD = PRINT;
            }
        }

        public static enum TransformName {
            THIRD_LEFT(ItemDisplayContext.THIRD_PERSON_LEFT_HAND),
            THIRD_RIGHT(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND),
            FIRST_LEFT(ItemDisplayContext.FIRST_PERSON_LEFT_HAND),
            FIRST_RIGHT(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND),
            HEAD(ItemDisplayContext.HEAD),
            GUI(ItemDisplayContext.GUI),
            GROUND(ItemDisplayContext.GROUND),
            FIXED(ItemDisplayContext.FIXED),
            ON_SHELF(ItemDisplayContext.ON_SHELF);

            public static final TransformName[] VALUES;
            private final ItemDisplayContext vanillaType;

            public TransformName getNext() {
                for (TransformName transformName : VALUES) {
                    if (transformName.ordinal() != this.ordinal() + 1) continue;
                    return transformName;
                }
                return THIRD_LEFT;
            }

            public TransformName getPrevious() {
                for (TransformName transformName : VALUES) {
                    if (transformName.ordinal() != this.ordinal() - 1) continue;
                    return transformName;
                }
                return ON_SHELF;
            }

            public ItemDisplayContext getVanillaTransformType() {
                return this.vanillaType;
            }

            private TransformName(ItemDisplayContext vanillaType) {
                this.vanillaType = vanillaType;
            }

            public ItemTransform getItemTransform(ItemTransforms transforms) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> transforms.thirdPersonLeftHand();
                    case 1 -> transforms.thirdPersonRightHand();
                    case 2 -> transforms.firstPersonLeftHand();
                    case 3 -> transforms.firstPersonRightHand();
                    case 4 -> transforms.head();
                    case 5 -> transforms.gui();
                    case 6 -> transforms.ground();
                    case 7 -> transforms.fixed();
                    case 8 -> transforms.fixedFromBottom();
                };
            }

            static {
                VALUES = TransformName.values();
            }
        }
    }
}

