/*
 * Decompiled with CFR 0.152.
 */
package itemtransformhelper;

import com.google.common.collect.ImmutableMap;
import itemtransformhelper.MenuItemCameraTransforms;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HUDTextRenderer {
    private static final HUDInfoUpdateLink.SelectedField NOT_SELECTABLE = null;
    private static final int MED_GRAY_HALF_TRANSPARENT = 1873784752;
    private static final int GREEN_HALF_TRANSPARENT = 0x6F00FF00;
    private static final int LIGHT_GRAY = -2039584;
    private static final int BLACK = -16777216;
    private final HUDInfoUpdateLink hudInfoUpdateLink;

    public HUDTextRenderer(HUDInfoUpdateLink hudInfoUpdateLink) {
        this.hudInfoUpdateLink = hudInfoUpdateLink;
    }

    public void displayHUDText(class_332 guiGraphics) {
        if (this.hudInfoUpdateLink == null || !this.hudInfoUpdateLink.menuVisible) {
            return;
        }
        ArrayList<Object> displayText = new ArrayList<Object>();
        ArrayList<HUDInfoUpdateLink.SelectedField> selectableField = new ArrayList<HUDInfoUpdateLink.SelectedField>();
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("VIEW  ");
        selectableField.add(NOT_SELECTABLE);
        switch (this.hudInfoUpdateLink.selectedTransform.ordinal()) {
            case 0: {
                displayText.add("3rd-L");
                break;
            }
            case 1: {
                displayText.add("3rd-R");
                break;
            }
            case 2: {
                displayText.add("1st-L");
                break;
            }
            case 3: {
                displayText.add("1st-R");
                break;
            }
            case 4: {
                displayText.add("head");
                break;
            }
            case 5: {
                displayText.add("gui");
                break;
            }
            case 6: {
                displayText.add("grnd");
                break;
            }
            case 7: {
                displayText.add("fixed");
                break;
            }
            case 8: {
                displayText.add("shelf");
            }
        }
        class_804 transformation = this.hudInfoUpdateLink.getItemTransform();
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSFORM);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("SCALE");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%.2f", Float.valueOf(transformation.comp_3749().x())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_X);
        displayText.add("Y:" + String.format("%.2f", Float.valueOf(transformation.comp_3749().y())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_Y);
        displayText.add("Z:" + String.format("%.2f", Float.valueOf(transformation.comp_3749().z())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.SCALE_Z);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("ROTATE");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%3.0f", Float.valueOf(transformation.comp_3747().x())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_X);
        displayText.add("Y:" + String.format("%3.0f", Float.valueOf(transformation.comp_3747().y())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_Y);
        displayText.add("Z:" + String.format("%3.0f", Float.valueOf(transformation.comp_3747().z())));
        selectableField.add(HUDInfoUpdateLink.SelectedField.ROTATE_Z);
        double TRANSLATE_MULTIPLIER = 16.0;
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("TRANSL");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("X:" + String.format("%.2f", (double)transformation.comp_3748().x() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_X);
        displayText.add("Y:" + String.format("%.2f", (double)transformation.comp_3748().y() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_Y);
        displayText.add("Z:" + String.format("%.2f", (double)transformation.comp_3748().z() * 16.0));
        selectableField.add(HUDInfoUpdateLink.SelectedField.TRANSLATE_Z);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        displayText.add("RESET");
        selectableField.add(HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT);
        displayText.add("RSTALL");
        selectableField.add(HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT_ALL);
        displayText.add("PRINT");
        selectableField.add(HUDInfoUpdateLink.SelectedField.PRINT);
        displayText.add("======");
        selectableField.add(NOT_SELECTABLE);
        class_327 font = class_310.method_1551().field_1772;
        int yPos = 2;
        int xPos = 2;
        for (int i = 0; i < displayText.size(); ++i) {
            String msg = (String)displayText.get(i);
            Objects.requireNonNull(font);
            yPos += 9;
            if (msg == null) continue;
            boolean fieldIsSelected = this.hudInfoUpdateLink.selectedField == selectableField.get(i);
            int highlightColour = fieldIsSelected ? 0x6F00FF00 : 1873784752;
            int n = xPos + font.method_1727(msg) + 1;
            Objects.requireNonNull(font);
            guiGraphics.method_25294(xPos - 1, yPos - 1, n, yPos + 9 - 1, highlightColour);
            int stringColour = fieldIsSelected ? -16777216 : -2039584;
            guiGraphics.method_51433(font, msg, xPos, yPos, stringColour, false);
        }
    }

    public static class HUDInfoUpdateLink {
        private static final Vector3f ROTATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f TRANSLATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f SCALE_DEFAULT = new Vector3f(1.0f, 1.0f, 1.0f);
        public class_809 itemCameraTransforms;
        public SelectedField selectedField;
        public TransformName selectedTransform;
        public boolean menuVisible;

        public HUDInfoUpdateLink() {
            class_804 trThirdLeft = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trThirdRight = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trFirstLeft = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trFirstRight = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trHead = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trGui = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trGround = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trFixed = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            class_804 trOnShelf = new class_804((Vector3fc)ROTATION_DEFAULT, (Vector3fc)TRANSLATION_DEFAULT, (Vector3fc)SCALE_DEFAULT);
            this.itemCameraTransforms = MenuItemCameraTransforms.newItemTransforms(trThirdLeft, trThirdRight, trFirstLeft, trFirstRight, trHead, trGui, trGround, trFixed, trOnShelf, (ImmutableMap<class_811, class_804>)ImmutableMap.of());
            this.selectedField = SelectedField.TRANSFORM;
            this.selectedTransform = TransformName.FIRST_RIGHT;
            this.menuVisible = false;
        }

        public class_804 getItemTransform() {
            return this.selectedTransform.getItemTransform(this.itemCameraTransforms);
        }

        public Vector3fc getItemTransformVec() {
            return this.selectedField.getItemTransformVec(this.itemCameraTransforms, this.selectedTransform);
        }

        public float getItemTransformVecValue() {
            return this.selectedField.getItemTransformVecValue(this.itemCameraTransforms, this.selectedTransform);
        }

        public static enum SelectedField {
            TRANSFORM(0),
            SCALE_X(1),
            SCALE_Y(2),
            SCALE_Z(3),
            ROTATE_X(4),
            ROTATE_Y(5),
            ROTATE_Z(6),
            TRANSLATE_X(7),
            TRANSLATE_Y(8),
            TRANSLATE_Z(9),
            RESTORE_DEFAULT(10),
            RESTORE_DEFAULT_ALL(11),
            PRINT(12);

            public static final SelectedField[] VALUES;
            private static final SelectedField FIRST_FIELD;
            private static final SelectedField LAST_FIELD;
            public final int fieldIndex;

            private SelectedField(int index) {
                this.fieldIndex = index;
            }

            public static SelectedField getFieldName(int indexToFind) {
                for (SelectedField checkField : VALUES) {
                    if (checkField.fieldIndex != indexToFind) continue;
                    return checkField;
                }
                return null;
            }

            public SelectedField getNextField() {
                SelectedField nextField = SelectedField.getFieldName(this.fieldIndex + 1);
                if (nextField == null) {
                    nextField = FIRST_FIELD;
                }
                return nextField;
            }

            public SelectedField getPreviousField() {
                SelectedField previousField = SelectedField.getFieldName(this.fieldIndex - 1);
                if (previousField == null) {
                    previousField = LAST_FIELD;
                }
                return previousField;
            }

            public Vector3fc getItemTransformVec(class_809 transforms, TransformName selectedTransform) {
                class_804 transform = selectedTransform.getItemTransform(transforms);
                if (this.isScale()) {
                    return transform.comp_3749();
                }
                if (this.isRotation()) {
                    return transform.comp_3747();
                }
                if (this.isTranslation()) {
                    return transform.comp_3748();
                }
                return null;
            }

            public float getItemTransformVecValue(class_809 transforms, TransformName selectedTransform) {
                Vector3fc vec = this.getItemTransformVec(transforms, selectedTransform);
                if (this.isX()) {
                    return Objects.requireNonNull(vec).x();
                }
                if (this.isY()) {
                    return Objects.requireNonNull(vec).y();
                }
                if (this.isZ()) {
                    return Objects.requireNonNull(vec).z();
                }
                return 0.0f;
            }

            public boolean isScale() {
                return this == SCALE_X || this == SCALE_Y || this == SCALE_Z;
            }

            public boolean isRotation() {
                return this == ROTATE_X || this == ROTATE_Y || this == ROTATE_Z;
            }

            public boolean isTranslation() {
                return this == TRANSLATE_X || this == TRANSLATE_Y || this == TRANSLATE_Z;
            }

            public boolean isX() {
                return this == SCALE_X || this == ROTATE_X || this == TRANSLATE_X;
            }

            public boolean isY() {
                return this == SCALE_Y || this == ROTATE_Y || this == TRANSLATE_Y;
            }

            public boolean isZ() {
                return this == SCALE_Z || this == ROTATE_Z || this == TRANSLATE_Z;
            }

            static {
                VALUES = SelectedField.values();
                FIRST_FIELD = TRANSFORM;
                LAST_FIELD = PRINT;
            }
        }

        public static enum TransformName {
            THIRD_LEFT(class_811.field_4323),
            THIRD_RIGHT(class_811.field_4320),
            FIRST_LEFT(class_811.field_4321),
            FIRST_RIGHT(class_811.field_4322),
            HEAD(class_811.field_4316),
            GUI(class_811.field_4317),
            GROUND(class_811.field_4318),
            FIXED(class_811.field_4319),
            ON_SHELF(class_811.field_61988);

            public static final TransformName[] VALUES;
            private final class_811 vanillaType;

            public TransformName getNext() {
                for (TransformName transformName : VALUES) {
                    if (transformName.ordinal() != this.ordinal() + 1) continue;
                    return transformName;
                }
                return THIRD_LEFT;
            }

            public TransformName getPrevious() {
                for (TransformName transformName : VALUES) {
                    if (transformName.ordinal() != this.ordinal() - 1) continue;
                    return transformName;
                }
                return ON_SHELF;
            }

            public class_811 getVanillaTransformType() {
                return this.vanillaType;
            }

            private TransformName(class_811 vanillaType) {
                this.vanillaType = vanillaType;
            }

            public class_804 getItemTransform(class_809 transforms) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> transforms.comp_3368();
                    case 1 -> transforms.comp_3369();
                    case 2 -> transforms.comp_3370();
                    case 3 -> transforms.comp_3371();
                    case 4 -> transforms.comp_3372();
                    case 5 -> transforms.comp_3373();
                    case 6 -> transforms.comp_3374();
                    case 7 -> transforms.comp_3375();
                    case 8 -> transforms.comp_4619();
                };
            }

            static {
                VALUES = TransformName.values();
            }
        }
    }
}

