/*
 * Decompiled with CFR 0.152.
 */
package itemtransformhelper;

import com.google.common.collect.ImmutableMap;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import itemtransformhelper.HUDTextRenderer;
import itemtransformhelper.UpdateLink;
import itemtransformhelper.fabric.MenuItemCameraTransformsImpl;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

public class MenuItemCameraTransforms {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HUDTextRenderer.HUDInfoUpdateLink linkToHudRenderer = new HUDTextRenderer.HUDInfoUpdateLink();

    public MenuItemCameraTransforms() {
        MenuKeyHandler menuKeyHandler = new MenuKeyHandler(new KeyPressCallback());
        ClientTickEvent.CLIENT_PRE.register(mc -> menuKeyHandler.clientTick());
        MenuItemCameraTransforms.registerListeners(new HUDTextRenderer(this.linkToHudRenderer));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerListeners(HUDTextRenderer hudTextRenderer) {
        MenuItemCameraTransformsImpl.registerListeners(hudTextRenderer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_809 newItemTransforms(class_804 thirdPersonLeftHand, class_804 thirdPersonRightHand, class_804 firstPersonLeftHand, class_804 firstPersonRightHand, class_804 head, class_804 gui, class_804 ground, class_804 fixed, class_804 onShelf, ImmutableMap<class_811, class_804> moddedTransforms) {
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return MenuItemCameraTransformsImpl.newItemTransforms(thirdPersonLeftHand, (class_804)var1_1, (class_804)var2_2, (class_804)var3_3, (class_804)var4_4, (class_804)var5_5, (class_804)var6_6, (class_804)var7_7, (class_804)var8_8, (ImmutableMap<class_811, class_804>)var9_9);
    }

    public class_809 getItemCameraTransforms() {
        return this.linkToHudRenderer.itemCameraTransforms;
    }

    public void changeMenuVisible(boolean visible) {
        this.linkToHudRenderer.menuVisible = visible;
    }

    private void alterField(boolean increase) {
        class_804 transform = this.linkToHudRenderer.getItemTransform();
        if (transform == null) {
            return;
        }
        float SCALE_INCREMENT = 0.01f;
        float ROTATION_INCREMENT = 2.0f;
        float TRANSLATION_INCREMENT = 0.015625f;
        switch (this.linkToHudRenderer.selectedField) {
            case TRANSFORM: {
                this.linkToHudRenderer.selectedTransform = increase ? this.linkToHudRenderer.selectedTransform.getNext() : this.linkToHudRenderer.selectedTransform.getPrevious();
                break;
            }
            case SCALE_X: 
            case SCALE_Y: 
            case SCALE_Z: {
                this.changeSelectedField(f -> Float.valueOf(f.floatValue() + (increase ? 0.01f : -0.01f)));
                break;
            }
            case ROTATE_X: 
            case ROTATE_Y: 
            case ROTATE_Z: {
                this.changeSelectedField(f -> Float.valueOf(class_3532.method_15393((float)(f.floatValue() + (increase ? 2.0f : -2.0f) - 180.0f)) + 180.0f));
                break;
            }
            case TRANSLATE_X: 
            case TRANSLATE_Y: 
            case TRANSLATE_Z: {
                this.changeSelectedField(f -> Float.valueOf(f.floatValue() + (increase ? 0.015625f : -0.015625f)));
                break;
            }
            case RESTORE_DEFAULT_ALL: 
            case RESTORE_DEFAULT: {
                class_809 originalTransforms = UpdateLink.INSTANCE.originalTransforms;
                if (originalTransforms == null) break;
                UpdateLink.INSTANCE.originalTransforms = null;
                if (this.linkToHudRenderer.selectedField == HUDTextRenderer.HUDInfoUpdateLink.SelectedField.RESTORE_DEFAULT) {
                    this.linkToHudRenderer.itemCameraTransforms = MenuItemCameraTransforms.changeTransforms(this.linkToHudRenderer.itemCameraTransforms, this.linkToHudRenderer.selectedTransform, this.linkToHudRenderer.selectedTransform.getItemTransform(originalTransforms));
                    break;
                }
                this.linkToHudRenderer.itemCameraTransforms = originalTransforms;
                break;
            }
            case PRINT: {
                StringBuilder output = new StringBuilder();
                output.append("\n\"display\": {\n");
                MenuItemCameraTransforms.printTransform(output, "thirdperson_righthand", this.linkToHudRenderer.itemCameraTransforms.comp_3369());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "thirdperson_lefthand", this.linkToHudRenderer.itemCameraTransforms.comp_3368());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "firstperson_righthand", this.linkToHudRenderer.itemCameraTransforms.comp_3371());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "firstperson_lefthand", this.linkToHudRenderer.itemCameraTransforms.comp_3370());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "gui", this.linkToHudRenderer.itemCameraTransforms.comp_3373());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "head", this.linkToHudRenderer.itemCameraTransforms.comp_3372());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "fixed", this.linkToHudRenderer.itemCameraTransforms.comp_3375());
                output.append(",\n");
                MenuItemCameraTransforms.printTransform(output, "ground", this.linkToHudRenderer.itemCameraTransforms.comp_3374());
                output.append("\n}");
                LOGGER.info((CharSequence)output);
                class_5250 text = class_2561.method_43470((String)"\"display\" JSON section printed to console (LOGGER.info)...");
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)text);
            }
        }
    }

    private void changeSelectedField(UnaryOperator<Float> modifier) {
        this.linkToHudRenderer.itemCameraTransforms = MenuItemCameraTransforms.changeTransforms(this.linkToHudRenderer.itemCameraTransforms, this.linkToHudRenderer.selectedTransform, MenuItemCameraTransforms.changeTransform(this.linkToHudRenderer.getItemTransform(), this.linkToHudRenderer.selectedField, MenuItemCameraTransforms.changeVec(this.linkToHudRenderer.getItemTransformVec(), this.linkToHudRenderer.selectedField, ((Float)modifier.apply(Float.valueOf(this.linkToHudRenderer.getItemTransformVecValue()))).floatValue())));
    }

    public static class_809 changeTransforms(class_809 old, HUDTextRenderer.HUDInfoUpdateLink.TransformName selectedTransform, class_804 newTransform) {
        return MenuItemCameraTransforms.newItemTransforms(selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.THIRD_LEFT ? newTransform : old.comp_3368(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.THIRD_RIGHT ? newTransform : old.comp_3369(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIRST_LEFT ? newTransform : old.comp_3370(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIRST_RIGHT ? newTransform : old.comp_3371(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.HEAD ? newTransform : old.comp_3372(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.GUI ? newTransform : old.comp_3373(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.GROUND ? newTransform : old.comp_3374(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.FIXED ? newTransform : old.comp_3375(), selectedTransform == HUDTextRenderer.HUDInfoUpdateLink.TransformName.ON_SHELF ? newTransform : old.comp_4619(), (ImmutableMap<class_811, class_804>)ImmutableMap.of());
    }

    public static class_804 changeTransform(class_804 old, HUDTextRenderer.HUDInfoUpdateLink.SelectedField selectedField, Vector3fc newTransform) {
        return new class_804(selectedField.isRotation() ? newTransform : old.comp_3747(), selectedField.isTranslation() ? newTransform : old.comp_3748(), selectedField.isScale() ? newTransform : old.comp_3749());
    }

    public static Vector3fc changeVec(Vector3fc old, HUDTextRenderer.HUDInfoUpdateLink.SelectedField selectedField, float newValue) {
        return new Vector3f(selectedField.isX() ? newValue : old.x(), selectedField.isY() ? newValue : old.y(), selectedField.isZ() ? newValue : old.z());
    }

    private static void printTransform(StringBuilder output, String transformView, class_804 transformation) {
        Locale LOCALE = Locale.US;
        output.append("    \"").append(transformView).append("\": {\n");
        output.append(String.format(LOCALE, "        \"rotation\": [ %.0f, %.0f, %.0f ],\n", Float.valueOf(transformation.comp_3747().x()), Float.valueOf(transformation.comp_3747().y()), Float.valueOf(transformation.comp_3747().z())));
        double TRANSLATE_MULTIPLIER = 16.0;
        output.append(String.format(LOCALE, "        \"translation\": [ %.2f, %.2f, %.2f ],\n", (double)transformation.comp_3748().x() * 16.0, (double)transformation.comp_3748().y() * 16.0, (double)transformation.comp_3748().z() * 16.0));
        output.append(String.format(LOCALE, "        \"scale\": [ %.2f, %.2f, %.2f ]\n", Float.valueOf(transformation.comp_3749().x()), Float.valueOf(transformation.comp_3749().y()), Float.valueOf(transformation.comp_3749().z())));
        output.append("    }");
    }

    public static class MenuKeyHandler {
        private final KeyPressCallback keyPressCallback;
        private long keyDownTimeTicks = 0L;
        private ArrowKeys lastKey = ArrowKeys.NONE;

        public MenuKeyHandler(KeyPressCallback keyPressCallback) {
            this.keyPressCallback = keyPressCallback;
        }

        public void clientTick() {
            int INITIAL_PAUSE_TICKS = 10;
            ArrowKeys keyPressed = ArrowKeys.NONE;
            if (MenuKeyHandler.isKeyDown(263)) {
                keyPressed = ArrowKeys.LEFT;
            }
            if (MenuKeyHandler.isKeyDown(262)) {
                keyPressed = ArrowKeys.RIGHT;
            }
            if (MenuKeyHandler.isKeyDown(264)) {
                keyPressed = ArrowKeys.DOWN;
            }
            if (MenuKeyHandler.isKeyDown(265)) {
                keyPressed = ArrowKeys.UP;
            }
            if (keyPressed == ArrowKeys.NONE) {
                this.lastKey = ArrowKeys.NONE;
                return;
            }
            if (keyPressed != this.lastKey) {
                this.lastKey = keyPressed;
                this.keyDownTimeTicks = 0L;
            } else if (++this.keyDownTimeTicks < 10L) {
                return;
            }
            this.keyPressCallback.keyPressed(keyPressed);
        }

        private static boolean isKeyDown(int key) {
            return GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)key) == 1;
        }

        public static enum ArrowKeys {
            NONE,
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    public class KeyPressCallback {
        void keyPressed(MenuKeyHandler.ArrowKeys whichKey) {
            if (!MenuItemCameraTransforms.this.linkToHudRenderer.menuVisible) {
                return;
            }
            switch (whichKey.ordinal()) {
                case 2: {
                    MenuItemCameraTransforms.this.linkToHudRenderer.selectedField = MenuItemCameraTransforms.this.linkToHudRenderer.selectedField.getNextField();
                    break;
                }
                case 1: {
                    MenuItemCameraTransforms.this.linkToHudRenderer.selectedField = MenuItemCameraTransforms.this.linkToHudRenderer.selectedField.getPreviousField();
                    break;
                }
                case 3: 
                case 4: {
                    MenuItemCameraTransforms.this.alterField(whichKey == MenuKeyHandler.ArrowKeys.RIGHT);
                    break;
                }
            }
        }
    }
}

