/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.intmending.event;

import java.util.ArrayList;
import net.exavior.intmending.registry.IMConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

@EventBusSubscriber(modid="intmending")
public class IMEvents {
    private static boolean containsMending(ItemEnchantments enchantments) {
        return enchantments.keySet().stream().anyMatch(holder -> holder.is(Enchantments.MENDING));
    }

    private static void stripMending(ItemStack stack) {
        ItemEnchantments storedEnchantments;
        ItemEnchantments itemEnchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (itemEnchantments != null && IMEvents.containsMending(itemEnchantments)) {
            ItemEnchantments.Mutable mutableEnchants = new ItemEnchantments.Mutable(itemEnchantments);
            mutableEnchants.removeIf(holder -> holder.is(Enchantments.MENDING));
            ItemEnchantments newEnchantments = mutableEnchants.toImmutable();
            stack.set(DataComponents.ENCHANTMENTS, (Object)newEnchantments);
        }
        if ((storedEnchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)) != null && IMEvents.containsMending(storedEnchantments)) {
            ItemEnchantments.Mutable mutableStoredEnchants = new ItemEnchantments.Mutable(storedEnchantments);
            mutableStoredEnchants.removeIf(holder -> holder.is(Enchantments.MENDING));
            ItemEnchantments newStoredEnchantments = mutableStoredEnchants.toImmutable();
            stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)newStoredEnchantments);
        }
    }

    @SubscribeEvent
    public static void onXpPickupForRepair(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        ExperienceOrb orb = event.getOrb();
        if (player.level().isClientSide || orb.value <= 0) {
            return;
        }
        ArrayList<ItemStack> repairableItems = new ArrayList<ItemStack>();
        for (ItemStack stack : player.getAllSlots()) {
            if (!stack.isDamageableItem() || !stack.isDamaged()) continue;
            repairableItems.add(stack);
        }
        if (repairableItems.isEmpty()) {
            return;
        }
        RandomSource random = player.getRandom();
        ItemStack stackToRepair = (ItemStack)repairableItems.get(random.nextInt(repairableItems.size()));
        int xpValue = orb.value;
        int potentialRepairAmount = xpValue * IMConfig.SERVER.repairProduct.getAsInt();
        int actualRepairApplied = Math.min(potentialRepairAmount, stackToRepair.getDamageValue());
        stackToRepair.setDamageValue(stackToRepair.getDamageValue() - actualRepairApplied);
        int xpConsumed = actualRepairApplied / IMConfig.SERVER.repairProduct.getAsInt();
        if (IMConfig.SERVER.consumeXP.getAsBoolean()) {
            orb.value -= xpConsumed;
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.2f + player.getRandom().nextFloat() * 0.2f);
            if (orb.value <= 0) {
                orb.discard();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        event.getEntity().getInventory().items.forEach(IMEvents::stripMending);
        event.getEntity().getInventory().armor.forEach(IMEvents::stripMending);
        event.getEntity().getInventory().offhand.forEach(IMEvents::stripMending);
    }

    @SubscribeEvent
    public static void onItemCollected(ItemEntityPickupEvent.Pre event) {
        IMEvents.stripMending(event.getItemEntity().getItem());
    }

    @SubscribeEvent
    public static void onItemCollected(ItemEntityPickupEvent.Post event) {
        IMEvents.stripMending(event.getItemEntity().getItem());
    }

    @SubscribeEvent
    public static void onAnvilRepair(AnvilUpdateEvent event) {
        boolean hasMending;
        ItemEnchantments itemEnchantmentsLeft = (ItemEnchantments)event.getLeft().get(DataComponents.ENCHANTMENTS);
        ItemEnchantments storedEnchantmentsLeft = (ItemEnchantments)event.getLeft().get(DataComponents.STORED_ENCHANTMENTS);
        ItemEnchantments itemEnchantmentsRight = (ItemEnchantments)event.getRight().get(DataComponents.ENCHANTMENTS);
        ItemEnchantments storedEnchantmentsRight = (ItemEnchantments)event.getRight().get(DataComponents.STORED_ENCHANTMENTS);
        boolean bl = hasMending = itemEnchantmentsLeft != null && IMEvents.containsMending(itemEnchantmentsLeft) || storedEnchantmentsLeft != null && IMEvents.containsMending(storedEnchantmentsLeft) || itemEnchantmentsRight != null && IMEvents.containsMending(itemEnchantmentsRight) || storedEnchantmentsRight != null && IMEvents.containsMending(storedEnchantmentsRight);
        if (hasMending) {
            System.out.println("Mending");
            event.setCanceled(true);
            event.setOutput(ItemStack.EMPTY);
        }
    }

    @SubscribeEvent
    public static void onGrindstoneProcess(GrindstoneEvent.OnTakeItem event) {
        IMEvents.stripMending(event.getNewBottomItem());
        IMEvents.stripMending(event.getNewTopItem());
    }
}

