/*
 * Decompiled with CFR 0.152.
 */
package com.ss;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class SeamlessShaders
implements ClientModInitializer {
    private static class_304 nextShaderKey;
    private static class_304 previousShaderKey;
    private static List<String> shaderPacks;
    private static int currentShaderIndex;
    private static boolean initialized;

    public void onInitializeClient() {
        nextShaderKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shaderswitcher.next", class_3675.class_307.field_1668, 262, "category.shaderswitcher"));
        previousShaderKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shaderswitcher.previous", class_3675.class_307.field_1668, 263, "category.shaderswitcher"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (!initialized) {
                this.loadShaderPacks();
                initialized = true;
            }
            while (nextShaderKey.method_1436()) {
                this.cycleShader(true);
            }
            while (previousShaderKey.method_1436()) {
                this.cycleShader(false);
            }
        });
    }

    private void loadShaderPacks() {
        shaderPacks.clear();
        shaderPacks.add("(internal)");
        try {
            File[] files;
            File shaderpacksDir = new File(class_310.method_1551().field_1697, "shaderpacks");
            if (shaderpacksDir.exists() && shaderpacksDir.isDirectory() && (files = shaderpacksDir.listFiles()) != null) {
                for (File file : files) {
                    if (file.isFile() && file.getName().endsWith(".zip")) {
                        shaderPacks.add(file.getName());
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    shaderPacks.add(file.getName());
                }
            }
            Collections.sort(shaderPacks.subList(1, shaderPacks.size()));
            String currentShader = this.getCurrentShaderPack();
            currentShaderIndex = Math.max(0, shaderPacks.indexOf(currentShader));
        }
        catch (Exception e) {
            System.err.println("Error loading shader packs: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void cycleShader(boolean forward) {
        if (shaderPacks.isEmpty()) {
            this.loadShaderPacks();
            if (shaderPacks.isEmpty()) {
                return;
            }
        }
        currentShaderIndex = forward ? (currentShaderIndex + 1) % shaderPacks.size() : (currentShaderIndex - 1 + shaderPacks.size()) % shaderPacks.size();
        String newShader = shaderPacks.get(currentShaderIndex);
        this.setShaderPack(newShader);
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            String displayName = newShader.equals("(internal)") ? "None" : newShader;
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76Shader: \u00a7f" + displayName)), true);
        }
    }

    private String getCurrentShaderPack() {
        try {
            Class<?> irisClass = Class.forName("net.irisshaders.iris.Iris");
            Method getIrisConfigMethod = irisClass.getMethod("getIrisConfig", new Class[0]);
            Object irisConfig = getIrisConfigMethod.invoke(null, new Object[0]);
            Method getShaderPackNameMethod = irisConfig.getClass().getMethod("getShaderPackName", new Class[0]);
            Object result = getShaderPackNameMethod.invoke(irisConfig, new Object[0]);
            if (result != null) {
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "(internal)";
    }

    private void setShaderPack(String packName) {
        block4: {
            try {
                Class<?> irisClass = Class.forName("net.irisshaders.iris.Iris");
                Method getIrisConfigMethod = irisClass.getMethod("getIrisConfig", new Class[0]);
                Object irisConfig = getIrisConfigMethod.invoke(null, new Object[0]);
                Method setShaderPackNameMethod = irisConfig.getClass().getMethod("setShaderPackName", String.class);
                setShaderPackNameMethod.invoke(irisConfig, packName);
                Method setShadersEnabledMethod = irisConfig.getClass().getMethod("setShadersEnabled", Boolean.TYPE);
                setShadersEnabledMethod.invoke(irisConfig, !packName.equals("(internal)"));
                try {
                    Method saveMethod = irisConfig.getClass().getMethod("save", new Class[0]);
                    saveMethod.invoke(irisConfig, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("Warning: Could not save Iris config: " + e.getMessage());
                }
                Method reloadMethod = irisClass.getMethod("reload", new Class[0]);
                reloadMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Error setting shader pack: " + e.getMessage());
                e.printStackTrace();
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) break block4;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFailed to switch shader. Check logs for details."), false);
            }
        }
    }

    static {
        shaderPacks = new ArrayList<String>();
        currentShaderIndex = -1;
        initialized = false;
    }
}

