/*
 * Decompiled with CFR 0.152.
 */
package com.cyborggrizzly.nocc.client;

import com.cyborggrizzly.nocc.client.ConfirmMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class NoccConfig {
    public ConfirmMode mode = ConfirmMode.OFF;
    public List<String> confirmPatterns = List.of("^/(op|deop|ban|kick|pardon|whitelist)\\b", "^/(stop|reload)\\b", "^/(data|nbt|setblock|fill|clone|summon|give)\\b", "^/tp\\b.*@a\\b");
    public List<String> bypassPatterns = List.of("^/(spawn|home|warp|msg|r|tpa|tpaccept)\\b");
    private static final Path PATH = Path.of("config", "no-command-confirm.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static NoccConfig INSTANCE;
    public transient List<Pattern> confirm = new ArrayList<Pattern>();
    public transient List<Pattern> bypass = new ArrayList<Pattern>();

    public static NoccConfig get() {
        if (INSTANCE == null) {
            INSTANCE = NoccConfig.load();
        }
        return INSTANCE;
    }

    public static void save() {
        try {
            Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(PATH, new OpenOption[0]);){
                GSON.toJson((Object)NoccConfig.get(), (Appendable)w);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NoccConfig load() {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) return new NoccConfig();
            try (BufferedReader r = Files.newBufferedReader(PATH);){
                NoccConfig c = (NoccConfig)GSON.fromJson((Reader)r, NoccConfig.class);
                if (c == null) return new NoccConfig();
                NoccConfig noccConfig = c;
                return noccConfig;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new NoccConfig();
    }

    public void cycleMode() {
        switch (this.mode) {
            case OFF: {
                this.mode = ConfirmMode.DANGEROUS_ONLY;
                break;
            }
            case DANGEROUS_ONLY: {
                this.mode = ConfirmMode.SAFE_LIST_ONLY;
                break;
            }
            case SAFE_LIST_ONLY: {
                this.mode = ConfirmMode.VANILLA;
                break;
            }
            case VANILLA: {
                this.mode = ConfirmMode.OFF;
            }
        }
    }

    public void compile() {
        this.confirm = this.confirmPatterns.stream().map(Pattern::compile).toList();
        this.bypass = this.bypassPatterns.stream().map(Pattern::compile).toList();
    }

    public boolean matchesAny(String s, List<Pattern> ps) {
        for (Pattern p : ps) {
            if (!p.matcher(s).find()) continue;
            return true;
        }
        return false;
    }

    public static class_7172<ConfirmMode> confirmModeOption() {
        NoccConfig cfg = NoccConfig.get();
        Codec codec = Codec.STRING.xmap(s -> ConfirmMode.valueOf(s.toUpperCase(Locale.ROOT)), m -> m.name().toLowerCase(Locale.ROOT));
        return new class_7172("nocc.options.confirm_mode", t -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"nocc.options.confirm_mode.tooltip")), (opt, value) -> class_2561.method_43471((String)("nocc.options.confirm_mode." + value.name().toLowerCase())), (class_7172.class_7178)new class_7172.class_7173(List.of(ConfirmMode.values()), codec), (Object)cfg.mode, newValue -> {
            cfg.mode = newValue;
            NoccConfig.save();
            cfg.compile();
        });
    }
}

