/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplegraves;

import com.flummidill.simplegraves.GraveManager;
import com.flummidill.simplegraves.SimpleGraves;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandHandler
implements CommandExecutor {
    private final SimpleGraves plugin;
    private final GraveManager manager;

    public CommandHandler(SimpleGraves plugin, GraveManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly Players can run this Command!");
            return true;
        }
        Player player = (Player)sender;
        this.manager.saveOfflinePlayer(player.getUniqueId(), player.getName());
        switch (cmd = command.getName().toLowerCase()) {
            case "graveinfo": {
                if (!player.hasPermission("simplegraves.graveinfo")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("Usage: /graveinfo <number>");
                    return true;
                }
                return this.handleGraveInfo(player, args);
            }
            case "graveadmin": {
                if (!player.hasPermission("simplegraves.graveadmin.show")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 2 && args.length != 3) {
                    player.sendMessage("Usage: /graveadmin <go|list|info|delete> [<player>] [<number>]");
                    return true;
                }
                return this.handleGraveAdmin(player, args);
            }
        }
        player.sendMessage("Usage: /graveadmin <go|list|info|delete> [<player>] [<number>]");
        return true;
    }

    private boolean handleGraveInfo(Player player, String[] args) {
        int graveNumber;
        UUID targetUUID = player.getUniqueId();
        try {
            graveNumber = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cGrave must be a Number.");
            return true;
        }
        this.manager.graveExistsUUID(targetUUID, graveNumber).thenAccept(exists -> {
            if (!exists.booleanValue()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a7cYou don't have a Grave with Number #" + graveNumber));
                return;
            }
            this.manager.getGraveLocation(targetUUID, graveNumber).thenAccept(location -> {
                if (location == null || location.getWorld() == null) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a7cFailed to retrieve the Grave Location"));
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> CommandHandler.lambda$handleGraveInfo$2(player, graveNumber, switch (location.getWorld().getName()) {
                    case "world" -> "The Overworld";
                    case "world_nether" -> "The Nether";
                    case "world_the_end" -> "The End";
                    default -> location.getWorld().getName();
                }, location));
            });
        });
        return true;
    }

    private boolean handleGraveAdmin(Player sender, String[] args) {
        String action = args[0].toLowerCase();
        String targetNameArg = args[1];
        String numberStr = args.length >= 3 ? args[2] : "-1";
        switch (action) {
            case "go": {
                if (sender.hasPermission("simplegraves.graveadmin.go")) break;
                sender.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                return true;
            }
            case "list": {
                if (sender.hasPermission("simplegraves.graveadmin.list")) break;
                sender.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                return true;
            }
            case "info": {
                if (sender.hasPermission("simplegraves.graveadmin.info")) break;
                sender.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                return true;
            }
            case "remove": {
                if (sender.hasPermission("simplegraves.graveadmin.remove")) break;
                sender.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                return true;
            }
            default: {
                sender.sendMessage("Usage: /graveadmin <go|list|info|remove> [<player>] [<number>]");
                return true;
            }
        }
        String targetNameFinal = targetNameArg;
        String numberStrFinal = numberStr;
        if (targetNameFinal.equals("*")) {
            if (!action.equals("remove")) {
                sender.sendMessage("\u00a7cYou can only use Player * with the remove Command.");
                return true;
            }
            if (numberStrFinal.equals("*")) {
                this.manager.removeEveryGrave();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved all Graves of all Players."));
            } else {
                int graveNumber;
                try {
                    graveNumber = Integer.parseInt(numberStrFinal);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cGrave must be a Number.");
                    return true;
                }
                int finalGraveNumber = graveNumber;
                this.manager.removeAllGravesWithNumber(finalGraveNumber);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved all Graves with Number #" + finalGraveNumber + "."));
            }
            return true;
        }
        Player onlineTarget = Bukkit.getPlayerExact((String)targetNameFinal);
        if (onlineTarget != null) {
            UUID targetUUID = onlineTarget.getUniqueId();
            int graveNumber = -1;
            if (!numberStrFinal.equals("-1") && !numberStrFinal.equals("*")) {
                try {
                    graveNumber = Integer.parseInt(numberStrFinal);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cGrave must be a Number.");
                    return true;
                }
            }
            int finalGraveNumber = graveNumber;
            switch (action) {
                case "go": {
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetNameFinal + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.getGraveLocation(targetUUID, finalGraveNumber).thenAccept(location -> {
                            if (location != null) {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                    sender.teleport(location);
                                    sender.sendMessage("\u00a7aTeleported to " + targetNameFinal + "'s Grave #" + finalGraveNumber);
                                });
                            } else {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cFailed to retrieve Grave Location."));
                            }
                        });
                    });
                    break;
                }
                case "list": {
                    this.manager.getGraveNumberListAsync(targetUUID).thenAccept(graveList -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (graveList.isEmpty()) {
                            sender.sendMessage("\u00a7c" + targetNameFinal + " currently has no Graves.");
                        } else {
                            sender.sendMessage("\u00a7a" + targetNameFinal + "'s Grave List:");
                            for (String graveNum : graveList) {
                                sender.sendMessage("\u00a7c#" + graveNum);
                            }
                        }
                    }));
                    break;
                }
                case "info": {
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetNameFinal + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.getGraveLocation(targetUUID, finalGraveNumber).thenAccept(location -> {
                            if (location == null || location.getWorld() == null) {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cFailed to retrieve the grave location or world."));
                                return;
                            }
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> CommandHandler.lambda$handleGraveAdmin$16(sender, targetNameFinal, finalGraveNumber, switch (location.getWorld().getName()) {
                                case "world" -> "The Overworld";
                                case "world_nether" -> "The Nether";
                                case "world_the_end" -> "The End";
                                default -> location.getWorld().getName();
                            }, location));
                        });
                    });
                    break;
                }
                case "remove": {
                    if (numberStrFinal.equals("*")) {
                        this.manager.removeAllGraves(targetUUID);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved all Graves of " + targetNameFinal + "."));
                        break;
                    }
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetNameFinal + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.removeGrave(targetUUID, finalGraveNumber, false);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved " + targetNameFinal + "'s Grave #" + finalGraveNumber));
                    });
                }
            }
            return true;
        }
        this.manager.getOfflinePlayerUUIDAsync(targetNameFinal).thenAccept(uuid -> this.manager.getOfflinePlayerName((UUID)uuid).thenAccept(name -> {
            if (uuid == null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cPlayer '" + targetNameFinal + "' not found."));
                return;
            }
            UUID targetUUID = uuid;
            String targetName = name;
            int graveNumber = -1;
            if (!numberStrFinal.equals("-1") && !numberStrFinal.equals("*")) {
                try {
                    graveNumber = Integer.parseInt(numberStrFinal);
                }
                catch (NumberFormatException e) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cGrave must be a Number."));
                    return;
                }
            }
            int finalGraveNumber = graveNumber;
            switch (action) {
                case "go": {
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.getGraveLocation(targetUUID, finalGraveNumber).thenAccept(location -> {
                            if (location != null) {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                    sender.teleport(location);
                                    sender.sendMessage("\u00a7aTeleported to " + targetName + "'s Grave #" + finalGraveNumber);
                                });
                            } else {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cFailed to retrieve Grave Location."));
                            }
                        });
                    });
                    break;
                }
                case "list": {
                    this.manager.getGraveNumberListAsync(targetUUID).thenAccept(graveList -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (graveList.isEmpty()) {
                            sender.sendMessage("\u00a7c" + targetName + " currently has no Graves.");
                        } else {
                            sender.sendMessage("\u00a7a" + targetName + "'s Grave List:");
                            for (String graveNum : graveList) {
                                sender.sendMessage("\u00a7c#" + graveNum);
                            }
                        }
                    }));
                    break;
                }
                case "info": {
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.getGraveLocation(targetUUID, finalGraveNumber).thenAccept(location -> {
                            if (location == null || location.getWorld() == null) {
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7cFailed to retrieve the grave location or world."));
                                return;
                            }
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> CommandHandler.lambda$handleGraveAdmin$34(sender, targetName, finalGraveNumber, switch (location.getWorld().getName()) {
                                case "world" -> "The Overworld";
                                case "world_nether" -> "The Nether";
                                case "world_the_end" -> "The End";
                                default -> location.getWorld().getName();
                            }, location));
                        });
                    });
                    break;
                }
                case "remove": {
                    if (numberStrFinal.equals("*")) {
                        this.manager.removeAllGraves(targetUUID);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved all Graves of " + targetName + "."));
                        break;
                    }
                    this.manager.graveExistsUUID(targetUUID, finalGraveNumber).thenAccept(exists -> {
                        if (!exists.booleanValue()) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7c" + targetName + " doesn't have a Grave with Number #" + finalGraveNumber));
                            return;
                        }
                        this.manager.removeGrave(targetUUID, finalGraveNumber, false);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aRemoved " + targetName + "'s Grave #" + finalGraveNumber));
                    });
                }
            }
        }));
        return true;
    }

    private static /* synthetic */ void lambda$handleGraveAdmin$34(Player sender, String targetName, int finalGraveNumber, String worldName, Location location) {
        sender.sendMessage("\u00a7a" + targetName + "'s Grave #" + finalGraveNumber + " is Located at:\n\u00a79World: \u00a7c" + worldName + "\n\u00a79X: \u00a7c" + Math.floor(location.getX()) + "\n\u00a79Y: \u00a7c" + Math.floor(location.getY()) + "\n\u00a79Z: \u00a7c" + Math.floor(location.getZ()));
    }

    private static /* synthetic */ void lambda$handleGraveAdmin$16(Player sender, String targetNameFinal, int finalGraveNumber, String worldName, Location location) {
        sender.sendMessage("\u00a7a" + targetNameFinal + "'s Grave #" + finalGraveNumber + " is Located at:\n\u00a79World: \u00a7c" + worldName + "\n\u00a79X: \u00a7c" + Math.floor(location.getX()) + "\n\u00a79Y: \u00a7c" + Math.floor(location.getY()) + "\n\u00a79Z: \u00a7c" + Math.floor(location.getZ()));
    }

    private static /* synthetic */ void lambda$handleGraveInfo$2(Player player, int graveNumber, String worldName, Location location) {
        player.sendMessage("\u00a7aGrave #" + graveNumber + " is Located at:\n\u00a79World: \u00a7c" + worldName + "\n\u00a79X: \u00a7c" + Math.floor(location.getX()) + "\n\u00a79Y: \u00a7c" + Math.floor(location.getY()) + "\n\u00a79Z: \u00a7c" + Math.floor(location.getZ()));
    }
}

