/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplegraves;

import com.flummidill.simplegraves.DatabaseWorker;
import com.flummidill.simplegraves.SimpleGraves;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class GraveManager {
    private final SimpleGraves plugin;
    public final Executor dbWorker;
    private final File dbFile;
    private Connection connection;
    private int xpLimit = 910;
    private boolean delete_vanishing_items = false;

    public GraveManager(SimpleGraves plugin, DatabaseWorker dbWorker) {
        this.plugin = plugin;
        this.dbWorker = query -> dbWorker.getDatabaseExecutor().execute(query);
        this.dbFile = new File(plugin.getDataFolder(), "graves.db");
        this.openConnection();
        this.createTables();
    }

    private void openConnection() {
        this.dbWorker.execute(() -> {
            try {
                if (!this.plugin.getDataFolder().exists()) {
                    this.plugin.getDataFolder().mkdirs();
                }
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Could not connect to SQLite database!");
                e.printStackTrace();
            }
        });
    }

    private void createTables() {
        this.dbWorker.execute(() -> {
            try (Statement stmt = this.connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS graves (uuid TEXT NOT NULL,grave_num INT NOT NULL,world TEXT NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,pitch DOUBLE NOT NULL,yaw DOUBLE NOT NULL,items TEXT NOT NULL,xp DOUBLE NOT NULL)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS offline_players (uuid TEXT NOT NULL,plr_name TEXT NOT NULL UNIQUE,PRIMARY KEY(uuid))");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to create tables in SQLite database.");
                e.printStackTrace();
            }
        });
    }

    public void createGrave(Player player, Location loc) {
        UUID uuid = player.getUniqueId();
        int graveNum = 1;
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO graves(uuid, grave_num, world, x, y, z, pitch, yaw, items, xp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            ps.setString(1, uuid.toString());
            try (PreparedStatement checkGraveNum = this.connection.prepareStatement("SELECT COALESCE(MAX(grave_num), 0) FROM graves WHERE uuid = ?");){
                checkGraveNum.setString(1, uuid.toString());
                ResultSet rs = checkGraveNum.executeQuery();
                if (rs.next()) {
                    graveNum = rs.getInt(1) + 1;
                }
                ps.setInt(2, graveNum);
            }
            if (loc.getWorld() == null) {
                player.sendMessage("\u00a7cFailed to create Grave!");
                this.plugin.getLogger().warning("Failed to create Grave for Player \"" + String.valueOf(uuid) + "\": Failed to determine Player's Dimension");
                return;
            }
            ps.setString(3, loc.getWorld().getName());
            double x = Math.floor(loc.getX()) + 0.5;
            double y = Math.floor(loc.getY()) + 0.5;
            double z = Math.floor(loc.getZ()) + 0.5;
            ps.setDouble(4, x);
            ps.setDouble(5, y);
            ps.setDouble(6, z);
            BlockFace graveRotation = BlockFace.NORTH;
            double pitch = 0.0;
            double yaw = 0.0;
            if (loc.getYaw() >= 135.0f && loc.getYaw() <= -135.0f) {
                yaw = 180.0;
                graveRotation = BlockFace.SOUTH;
            } else if (loc.getYaw() < 135.0f && loc.getYaw() > 45.0f) {
                yaw = 90.0;
                graveRotation = BlockFace.EAST;
            } else if (loc.getYaw() <= 45.0f && loc.getYaw() >= -45.0f) {
                yaw = 0.0;
                graveRotation = BlockFace.NORTH;
            } else if (loc.getYaw() < -45.0f && loc.getYaw() > -135.0f) {
                yaw = -90.0;
                graveRotation = BlockFace.WEST;
            }
            ps.setDouble(7, pitch);
            ps.setDouble(8, yaw);
            String player_items = Arrays.asList(player.getInventory().getContents()).stream().filter(Objects::nonNull).filter(item -> !this.delete_vanishing_items || !item.getEnchantments().containsKey(Enchantment.VANISHING_CURSE)).map(item -> {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    String string;
                    try (BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)baos);){
                        oos.writeObject(item);
                        string = Base64.getEncoder().encodeToString(baos.toByteArray());
                    }
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.joining("|"));
            ps.setString(9, player_items);
            double player_xp = this.getTotalXP(player);
            if (player_xp > (double)this.xpLimit) {
                player_xp = this.xpLimit;
            }
            ps.setDouble(10, player_xp);
            ps.executeUpdate();
            player.getInventory().clear();
            player.setTotalExperience(0);
            player.setLevel(0);
            player.setExp(0.0f);
            this.plugin.executeConsoleCommand("tellraw " + player.getName() + " [{\"text\":\"Your Grave \",\"color\":\"white\"},{\"text\":\"#" + graveNum + "\",\"color\":\"gold\"},{\"text\":\" is Located at \",\"color\":\"white\"},{\"text\":\"" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + "\",\"color\":\"gold\"},{\"text\":\" in \",\"color\":\"white\"}," + (String)(switch (loc.getWorld().getName()) {
                case "world" -> "{\"text\":\"The Overworld\",\"color\":\"green\"}";
                case "world_nether" -> "{\"text\":\"The Nether\",\"color\":\"red\"}";
                case "world_the_end" -> "{\"text\":\"The End\",\"color\":\"#ffffaa\"}";
                default -> "{\"text\":\"" + loc.getWorld().getName() + "\",\"color\":\"light_purple\"}";
            }) + "]");
            Block block = loc.getBlock();
            block.setType(Material.PLAYER_HEAD);
            Rotatable rot = (Rotatable)block.getBlockData();
            rot.setRotation(graveRotation);
            block.setBlockData((BlockData)rot);
            Skull skull = (Skull)block.getState();
            skull.setOwningPlayer((OfflinePlayer)player);
            skull.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<Boolean> graveExistsUUID(UUID uuid, int graveNum) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block8: {
                PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM graves WHERE uuid = ? AND grave_num = ?");
                try {
                    ps.setString(1, uuid.toString());
                    ps.setInt(2, graveNum);
                    bl = ps.executeQuery().next();
                    if (ps == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                ps.close();
            }
            return bl;
        }, this.dbWorker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean graveExistsLoc(Location loc) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM graves WHERE world = ? AND x =? AND y = ? AND z = ?");){
            if (loc.getWorld() == null) {
                this.plugin.getLogger().warning("Failed to determine Dimension of broken Block.");
                boolean bl2 = false;
                return bl2;
            }
            ps.setString(1, loc.getWorld().getName());
            double x = Math.floor(loc.getX()) + 0.5;
            double y = Math.floor(loc.getY()) + 0.5;
            double z = Math.floor(loc.getZ()) + 0.5;
            ps.setDouble(2, x);
            ps.setDouble(3, y);
            ps.setDouble(4, z);
            boolean bl = ps.executeQuery().next();
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getGraveNumberList(UUID uuid) {
        ArrayList<String> graveNumberList = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT grave_num FROM graves WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int graveNum = rs.getInt("grave_num");
                graveNumberList.add(String.valueOf(graveNum));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return graveNumberList;
    }

    public CompletableFuture<List<String>> getGraveNumberListAsync(UUID uuid) {
        UUID finalUUID = uuid;
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.dbWorker.execute(() -> {
            ArrayList<String> graveNumberList = new ArrayList<String>();
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT grave_num FROM graves WHERE uuid = ?");){
                ps.setString(1, finalUUID.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int graveNum = rs.getInt("grave_num");
                    graveNumberList.add(String.valueOf(graveNum));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(graveNumberList));
        });
        return future;
    }

    public CompletableFuture<Location> getGraveLocation(UUID uuid, int graveNum) {
        UUID finalUUID = uuid;
        int finalGraveNum = graveNum;
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        this.dbWorker.execute(() -> {
            Location graveLocation = null;
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM graves WHERE uuid = ? AND grave_num = ?");){
                World world;
                ps.setString(1, finalUUID.toString());
                ps.setInt(2, finalGraveNum);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (world = Bukkit.getWorld((String)rs.getString("world"))) != null) {
                    graveLocation = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), (float)rs.getDouble("yaw"), (float)rs.getDouble("pitch"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Location result = graveLocation;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(result));
        });
        return future;
    }

    public CompletableFuture<List<Location>> getAllGraveLocations(UUID uuid) {
        UUID finalUUID = uuid;
        CompletableFuture<List<Location>> future = new CompletableFuture<List<Location>>();
        this.dbWorker.execute(() -> {
            ArrayList<Location> graveLocations = new ArrayList<Location>();
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM graves WHERE uuid = ?");){
                ps.setString(1, finalUUID.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    World world = Bukkit.getWorld((String)rs.getString("world"));
                    if (world == null) continue;
                    Location location = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), (float)rs.getDouble("yaw"), (float)rs.getDouble("pitch"));
                    graveLocations.add(location);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(graveLocations));
        });
        return future;
    }

    public CompletableFuture<List<Location>> getAllGraveLocationsWithNumber(int graveNum) {
        int finalGraveNum = graveNum;
        CompletableFuture<List<Location>> future = new CompletableFuture<List<Location>>();
        this.dbWorker.execute(() -> {
            ArrayList<Location> graveLocations = new ArrayList<Location>();
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM graves WHERE grave_num = ?");){
                ps.setInt(1, finalGraveNum);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    World world = Bukkit.getWorld((String)rs.getString("world"));
                    if (world == null) continue;
                    Location location = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), (float)rs.getDouble("yaw"), (float)rs.getDouble("pitch"));
                    graveLocations.add(location);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(graveLocations));
        });
        return future;
    }

    public CompletableFuture<List<Location>> getEveryGraveLocation() {
        CompletableFuture<List<Location>> future = new CompletableFuture<List<Location>>();
        this.dbWorker.execute(() -> {
            ArrayList<Location> graveLocations = new ArrayList<Location>();
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM graves");){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    World world = Bukkit.getWorld((String)rs.getString("world"));
                    if (world == null) continue;
                    Location location = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), (float)rs.getDouble("yaw"), (float)rs.getDouble("pitch"));
                    graveLocations.add(location);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(graveLocations));
        });
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getGraveOwnerUUID(Location loc) {
        if (loc == null) return null;
        if (loc.getWorld() == null) {
            return null;
        }
        String worldName = loc.getWorld().getName();
        double x = Math.floor(loc.getX()) + 0.5;
        double y = Math.floor(loc.getY()) + 0.5;
        double z = Math.floor(loc.getZ()) + 0.5;
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT uuid FROM graves WHERE world = ? AND x = ? AND y = ? AND z = ?");){
            ps.setString(1, worldName);
            ps.setDouble(2, x);
            ps.setDouble(3, y);
            ps.setDouble(4, z);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString("uuid"));
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void breakGrave(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        String worldName = loc.getWorld().getName();
        double x = Math.floor(loc.getX()) + 0.5;
        double y = Math.floor(loc.getY()) + 0.5;
        double z = Math.floor(loc.getZ()) + 0.5;
        this.dbWorker.execute(() -> {
            try (PreparedStatement select = this.connection.prepareStatement("SELECT uuid, grave_num, items, xp FROM graves WHERE world = ? AND x = ? AND y = ? AND z = ?");){
                select.setString(1, worldName);
                select.setDouble(2, x);
                select.setDouble(3, y);
                select.setDouble(4, z);
                ResultSet rs = select.executeQuery();
                if (!rs.next()) {
                    return;
                }
                String uuid = rs.getString("uuid");
                String serializedItems = rs.getString("items");
                int graveNum = rs.getInt("grave_num");
                double xpAmount = rs.getDouble("xp");
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    int xpLeftOver;
                    int xpPerOrb;
                    int xpOrbCount;
                    String[] base64Items;
                    World world = Bukkit.getWorld((String)worldName);
                    Location dropLoc = new Location(world, x, y, z);
                    for (String base64 : base64Items = serializedItems.split("\\|")) {
                        if (base64.isEmpty()) continue;
                        try (ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
                             BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)bais);){
                            ItemStack item = (ItemStack)ois.readObject();
                            if (item == null || item.getType() == Material.AIR || world == null) continue;
                            world.dropItemNaturally(dropLoc, item);
                        }
                        catch (IOException | ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    if (xpAmount > 0.0 && xpAmount <= 25.0) {
                        xpOrbCount = (int)Math.floor(xpAmount);
                        xpPerOrb = 1;
                        xpLeftOver = 0;
                    } else if (xpAmount > 25.0) {
                        xpOrbCount = 25;
                        xpPerOrb = (int)Math.floor(xpAmount / 25.0);
                        xpLeftOver = (int)xpAmount - xpPerOrb * 25;
                    } else {
                        xpOrbCount = 0;
                        xpPerOrb = 0;
                        xpLeftOver = 0;
                    }
                    if (world != null) {
                        for (int i = 0; i < xpOrbCount; ++i) {
                            ((ExperienceOrb)world.spawn(dropLoc, ExperienceOrb.class)).setExperience(xpPerOrb);
                        }
                        if (xpLeftOver > 0) {
                            ((ExperienceOrb)world.spawn(dropLoc, ExperienceOrb.class)).setExperience(xpLeftOver);
                        }
                    }
                });
                try (PreparedStatement delete = this.connection.prepareStatement("DELETE FROM graves WHERE uuid = ? AND grave_num = ?");){
                    delete.setString(1, uuid);
                    delete.setInt(2, graveNum);
                    delete.executeUpdate();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void removeGrave(UUID uuid, int graveNum, boolean dropContents) {
        this.getGraveLocation(uuid, graveNum).thenAccept(graveLocation -> {
            if (graveLocation == null) {
                return;
            }
            World world = graveLocation.getWorld();
            if (world == null) {
                return;
            }
            Chunk chunk = graveLocation.getChunk();
            boolean wasLoaded = chunk.isLoaded();
            this.dbWorker.execute(() -> {
                if (!wasLoaded) {
                    world.loadChunk(chunk);
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Block graveBlock = graveLocation.getBlock();
                    if (graveBlock.getType() != Material.AIR) {
                        graveBlock.setType(Material.AIR);
                    }
                    if (dropContents) {
                        this.breakGrave((Location)graveLocation);
                    }
                    if (!wasLoaded) {
                        world.unloadChunk(chunk);
                    }
                    this.dbWorker.execute(() -> {
                        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM graves WHERE uuid = ? AND grave_num = ?");){
                            ps.setString(1, uuid.toString());
                            ps.setInt(2, graveNum);
                            ps.executeUpdate();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    });
                });
            });
        });
    }

    public void removeAllGraves(UUID uuid) {
        this.getAllGraveLocations(uuid).thenAccept(graveLocations -> {
            if (graveLocations.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Location graveLocation : graveLocations) {
                    Block graveBlock;
                    World world;
                    if (graveLocation == null || (world = graveLocation.getWorld()) == null) continue;
                    Chunk chunk = graveLocation.getChunk();
                    boolean wasLoaded = chunk.isLoaded();
                    if (!wasLoaded) {
                        world.loadChunk(chunk);
                    }
                    if ((graveBlock = graveLocation.getBlock()).getType() != Material.AIR) {
                        graveBlock.setType(Material.AIR);
                    }
                    if (wasLoaded) continue;
                    world.unloadChunk(chunk);
                }
            });
            this.dbWorker.execute(() -> {
                try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM graves WHERE uuid = ?");){
                    ps.setString(1, uuid.toString());
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public void removeAllGravesWithNumber(int graveNum) {
        this.getAllGraveLocationsWithNumber(graveNum).thenAccept(graveLocations -> {
            if (graveLocations.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Location graveLocation : graveLocations) {
                    Block graveBlock;
                    World world;
                    if (graveLocation == null || (world = graveLocation.getWorld()) == null) continue;
                    Chunk chunk = graveLocation.getChunk();
                    boolean wasLoaded = chunk.isLoaded();
                    if (!wasLoaded) {
                        world.loadChunk(chunk);
                    }
                    if ((graveBlock = graveLocation.getBlock()).getType() != Material.AIR) {
                        graveBlock.setType(Material.AIR);
                    }
                    if (wasLoaded) continue;
                    world.unloadChunk(chunk);
                }
            });
            this.dbWorker.execute(() -> {
                try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM graves WHERE grave_num = ?");){
                    ps.setInt(1, graveNum);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public void removeEveryGrave() {
        this.getEveryGraveLocation().thenAccept(graveLocations -> {
            if (graveLocations.isEmpty()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Location graveLocation : graveLocations) {
                    Block graveBlock;
                    World world;
                    if (graveLocation == null || (world = graveLocation.getWorld()) == null) continue;
                    Chunk chunk = graveLocation.getChunk();
                    boolean wasLoaded = chunk.isLoaded();
                    if (!wasLoaded) {
                        world.loadChunk(chunk);
                    }
                    if ((graveBlock = graveLocation.getBlock()).getType() != Material.AIR) {
                        graveBlock.setType(Material.AIR);
                    }
                    if (wasLoaded) continue;
                    world.unloadChunk(chunk);
                }
            });
            this.dbWorker.execute(() -> {
                try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM graves");){
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public void setMaxStordXP(int maxLevels) {
        this.xpLimit = maxLevels <= 16 ? maxLevels * maxLevels + 6 * maxLevels : (maxLevels <= 31 ? (int)Math.floor(2.5 * (double)(maxLevels * maxLevels) - 40.5 * (double)maxLevels + 360.0) : (int)Math.floor(4.5 * (double)(maxLevels * maxLevels) - 162.5 * (double)maxLevels + 2220.0));
    }

    public int getTotalXP(Player player) {
        int XPlevel = player.getLevel();
        if (XPlevel <= 16) {
            return XPlevel * XPlevel + 6 * XPlevel;
        }
        if (XPlevel <= 31) {
            return (int)Math.floor(2.5 * (double)(XPlevel * XPlevel) - 40.5 * (double)XPlevel + 360.0);
        }
        return (int)Math.floor(4.5 * (double)(XPlevel * XPlevel) - 162.5 * (double)XPlevel + 2220.0);
    }

    public void saveOfflinePlayer(UUID uuid, String playerName) {
        CompletableFuture.runAsync(() -> {
            try {
                boolean uuidExists = false;
                PreparedStatement ps1 = this.connection.prepareStatement("SELECT 1 FROM offline_players WHERE uuid = ? LIMIT 1");
                ps1.setString(1, uuid.toString());
                ResultSet rs1 = ps1.executeQuery();
                if (rs1.next()) {
                    uuidExists = true;
                }
                boolean nameExists = false;
                PreparedStatement ps2 = this.connection.prepareStatement("SELECT 1 FROM offline_players WHERE plr_name = ? LIMIT 1");
                ps2.setString(1, playerName);
                ResultSet rs2 = ps2.executeQuery();
                if (rs2.next()) {
                    nameExists = true;
                }
                if (uuidExists) {
                    PreparedStatement ps3 = this.connection.prepareStatement("DELETE FROM offline_players WHERE uuid = ?");
                    ps3.setString(1, uuid.toString());
                    ps3.executeUpdate();
                }
                if (nameExists) {
                    PreparedStatement ps4 = this.connection.prepareStatement("DELETE FROM offline_players WHERE plr_name = ?");
                    ps4.setString(1, playerName);
                    ps4.executeUpdate();
                }
                PreparedStatement ps5 = this.connection.prepareStatement("REPLACE INTO offline_players(uuid, plr_name) VALUES (?, ?)");
                ps5.setString(1, uuid.toString());
                ps5.setString(2, playerName);
                ps5.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public List<String> getOfflinePlayerNameList() {
        ArrayList<String> list = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT DISTINCT plr_name FROM offline_players");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString("plr_name");
                if (name == null) continue;
                list.add(name);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getOfflinePlayerUUID(String playerName) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT uuid FROM offline_players WHERE plr_name = ?");){
            ps.setString(1, playerName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            String uuid = rs.getString("uuid");
            if (uuid != null) {
                UUID uUID = UUID.fromString(uuid);
                return uUID;
            }
            UUID uUID = null;
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CompletableFuture<UUID> getOfflinePlayerUUIDAsync(String playerName) {
        return CompletableFuture.supplyAsync(() -> {
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT uuid FROM offline_players WHERE plr_name = ?");){
                ps.setString(1, playerName);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return null;
                String uuid = rs.getString("uuid");
                if (uuid == null) return null;
                UUID uUID = UUID.fromString(uuid);
                return uUID;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public CompletableFuture<String> getOfflinePlayerName(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM offline_players WHERE uuid = ?");){
                ps.setString(1, uuid.toString());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) return null;
                String string = rs.getString("plr_name");
                return string;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public void deleteVanishingItems() {
        this.delete_vanishing_items = true;
    }
}

